package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.util.drawing.Board;
import itez.core.util.drawing.BoardElement;
import itez.core.util.drawing.BoardElement.Type;
import itez.core.util.drawing.ImageElement;
import itez.core.util.drawing.TextElement;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.kit.EUid;
import itez.kit.El;
import itez.plat.main.model.DrawingElement;
import itez.plat.main.model.DrawingModel;
import itez.plat.main.service.DrawingElementService;
import itez.plat.main.service.DrawingModelService;
import itez.core.runtime.service.Define;

import java.awt.Color;
import java.util.List;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.Record;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class DrawingModelServiceImpl extends EModelService<DrawingModel> implements DrawingModelService {

	@Inject
	DrawingElementService elSer;
	
	@Override
	public List<DrawingModel> getByGroupCode(String groupCode) {
		Querys qs = Querys.and(Query.eq("groupCode", groupCode));
		return select(qs);
	}

	@Override
	public Board getBoard(String modelId, Record data, Kv para){
		return getBoard(findById(modelId), data, para);
	}

	@Override
	public Board getBoard(DrawingModel model, Record data, Kv para){
		return getBoard(null, model, null, null, null);
	}

	@Override
	public Board getBoard(String name, DrawingModel model, Record data, Kv para, Integer index){
		if(EStr.isEmpty(name)) name = EUid.generator();
		if(data == null) data = new Record();
		if(para == null) para = Kv.create();
		if(index == null) index = 0;
		Kv context = Kv.by("data", data).set("para", para).set("index", index);
		Color backColor = Board.parseFromRgb(model.getBackColor());
		Board board = new Board(name, backColor, model.getBackImage(), model.getWidth(), model.getHeight());
		List<DrawingElement> els = elSer.getByModelId(model.getId());
		els.forEach(el -> {
			BoardElement.Type type = Type.valueOf(el.getType());
			String val = el.getValue();
			if(EStr.notEmpty(val)) val = El.exec(val, context);
			if(EStr.isEmpty(val)) val = el.getDefaultValue();
			Integer width = el.getWidth();
			Integer height = el.getHeight();
			if(type == Type.IMAGE){
				ImageElement element = new ImageElement(val, el.getAtx(), el.getAty(), width, height);
				board.addElement(element);
			}else{
				TextElement element = new TextElement(val, el.getAtx(), el.getAty(), width, height);
				element.setFontSize(el.getFontSize());
				element.setFontName(el.getFontName());
				element.setFontStyle(el.getFontStyle());
				element.setColor(Board.parseFromRgb(el.getFontColor()));
				board.addElement(element);
			}
		});
		return board;
	}
	
}