package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.model.Selector;
import itez.plat.main.model.Dict;
import itez.plat.main.service.DictService;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;

import java.util.List;

import com.google.inject.Singleton;
import com.jfinal.plugin.activerecord.Page;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class DictServiceImpl extends EModelService<Dict> implements DictService {

	/**
	 * 检索指定分组的条目列表
	 * @param groupCode
	 * @return
	 */
	@Cache.able
	public List<Dict> getByGroup(String groupCode){
		Querys qs = Querys.and(Query.eq("groupCode", groupCode));
		Selector select = Selector.select("key", "value", "sort").where(qs);
		return select(select);
	}

	/**
	 * 检索指定分组的条目列表
	 * @param groupCode
	 * @return
	 */
	public Page<Dict> getPageByGroup(String groupCode, Integer pageNumber){
		Querys qs = Querys.and(Query.eq("groupCode", groupCode));
		Selector select = Selector.select("key", "value", "sort").where(qs);
		return paginate(pageNumber, 30, select);
	}

}