package itez.plat.main.service.impl;

import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EArr;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.kit.EUid;
import itez.kit.poi.ECell;
import itez.kit.poi.EPoi;
import itez.kit.poi.ERow;
import itez.kit.poi.ESheet;
import itez.kit.poi.Excel;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.plat.main.model.Dept;
import itez.plat.main.service.DeptService;
import itez.plat.wrapper.service.ETreeService;

import java.io.File;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;

import com.beust.jcommander.internal.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.IAtom;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class DeptServiceImpl extends ETreeService<Dept> implements DeptService {

	@Override
	@Cache.able(cache="DEPT_BY_ID", key="id")
	public Dept findById(String id) {
		return super.findById(id);
	}
	
	/**
	 * 返回tmid对应的机构
	 * @param tmid
	 * @return
	 */
	public Dept findByTmid(Object tmid) {
		Querys qs = Querys.and(Query.eq("tmid", tmid));
		return selectFirst(qs);
	}
	
	/**
	 * 创建默认部门
	 * @param comp
	 * @return
	 */
	public Dept createRootDept(){
		Dept dept = getRootDept();
		if(dept != null) return dept;
		dept = new Dept();
		dept.setCaption($comp().getCaption());
		dept.setSummary("默认部门");
		dept.setSort(1);
		dept.setPath(EStr.addPrefix(1, 3));
		save(dept);
		return dept;
	}
	
	public Dept getRootDept(){
		Querys qs = Querys.and(Query.nu("pid"));
		return selectFirst(qs);
	}

	public List<Dept> getAllDepts(){
		Querys qs = Querys.and(Query.nn("pid"));
		return select(qs, "path", null);
	}

	public List<Dept> getAllDepts(String pid){
		Dept dept = super.findById(pid);
		Querys qs = Querys.and(Query.like("path", dept.getPath() + "_%"));
		return select(qs, "path", null);
	}
	
	public List<Dept> getSubDepts(String pid){
		Querys qs = Querys.and(Query.eq("pid", pid));
		return select(qs);
	}
	
	public List<Dept> getDepts(String ids){
		Querys qs = Querys.and(Query.in("id", EStr.ids2sqlIn(ids)));
		return select(qs);
	}
	
	public List<Dept> getDepts(String ids, String orderby){
		Querys qs = Querys.and(Query.in("id", EStr.ids2sqlIn(ids)));
		return select(qs, "sort " + orderby);
	}
	
	public void addDept(Dept dept){
		save(dept);
	}
	
	@Cache.del(cache="DEPT_BY_ID", key="dept.id")
	public void modifyDept(Dept dept){
		update(dept);
	}
	
	@Cache.del(cache="DEPT_BY_ID", keys="ids")
	public void removeDepts(String ids){
		disableByIds(ids);
	}
	
	public Dept getLastDept(String pid){
		return super.getLast(pid);
	}

	@Cache.del(cache="DEPT_BY_ID", keys="ids")
	public void sort(String pid, String opt, String ids){
		super.sort(pid, opt, ids);
	}
	
	public int imports(String pid, File file){
		String domain = $domain();
		Excel excel = null;
		try {
			excel = EPoi.load(file);
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException("解析Excel文件时发送错误，请重新操作。");
		}
		ESheet sheet = excel.getSheet(0);
		int celCnt = sheet.getCellCount();
		int rowCnt = sheet.getRowCount();
		if(celCnt < 2 || rowCnt < 2) throw new RuntimeException("文件中未发现有效数据，导入失败。");
		String[] fields = { "parentDept", "dept" };
		Map<String, Integer> fieldIndex = Maps.newHashMap();
		List<ERow> rows = sheet.getRows();

		//数据列对照
		ERow header = rows.get(0);
		header.getCells().forEach(cell -> {
			Object val = cell.getValue();
			if(val != null){
				String caption = val.toString();
				if(ArrayUtils.contains(fields, caption)){
					fieldIndex.put(caption, cell.getCellIndex());
				}
			}
		});
		
		//必要数据列预审
		StringBuilder sb = new StringBuilder();
		Arrays.stream(fields).forEach(f -> {
			if(!fieldIndex.containsKey(f)){
				sb.append("，").append(f);
			}
		});
		if(sb.length() > 0) throw new RuntimeException("缺少必要数据列：" + sb.substring(1));

		Dept rootDept = findById(pid);
		Dept rootLast = getLastDept(pid);
		List<Dept> depts = Lists.newArrayList();
		Map<String, Kv> deptMap = Maps.newHashMap();
		depts.add(rootDept);
		deptMap.put(rootDept.getCaption(), Kv.by("index", 0).set("size", rootLast == null ? 0 : rootLast.getSort()));
		
		//开始执行导入
		for(ERow row : rows){
			if(row.getIndex() < 2) continue;
			List<ECell> cells = row.getCells();
			Object parentDeptObj = cells.get(fieldIndex.get("parentDept")).getValue();
			Object deptObj = cells.get(fieldIndex.get("dept")).getValue();
			
			if(EStr.isEmpty(parentDeptObj) || EStr.isEmpty(deptObj)) continue;
			
			String parentDeptCaption = formatNum(parentDeptObj);
			String deptCaption = formatNum(deptObj);
			
			if(parentDeptCaption.equals("[根机构]")) parentDeptCaption = rootDept.getCaption();
			
			Dept parentDept;
			String parentPath;
			int index, parentSize;
			
			Kv kv = deptMap.get(parentDeptCaption);
			if(kv == null) continue;
			
			index = kv.getInt("index");
			parentDept = depts.get(index);
			parentPath = parentDept.getPath();
			parentSize = kv.getInt("size");
			
			Dept dept = new Dept();
			dept.setDomain(domain);
			dept.setPid(parentDept.getId());
			dept.setId(EUid.generator());
			dept.setCaption(deptCaption);
			dept.setLevel(1);
			dept.setSort(++parentSize);
			dept.setPath(parentPath.concat("_").concat(EStr.addPrefix(dept.getSort(), 3)));
			dept.setUsed(1);

			depts.add(dept);
			deptMap.put(parentDeptCaption, kv.set("size", parentSize));
			deptMap.put(deptCaption, Kv.by("index", depts.size() - 1).set("size", 0));
		}
		
		depts.remove(0);
		
		if(depts.size() == 0) return 0;
		
		boolean state = dbo().tx(new IAtom(){
			@Override
			public boolean run() throws SQLException {
				int[] ret = dbo().batchSave(depts, depts.size());
				return EArr.vali(ret);
			}
		});
		
		return state ? depts.size() : 0;
	}
	
	private String formatNum(Object val){
		String valStr = EStr.isEmpty(val) ? "" : val.toString();
		return valStr.replaceAll("\\.0$", "");
	}

}