package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.runtime.session.EAttr;
import itez.plat.main.model.Countor;
import itez.plat.main.service.CountorService;
import itez.core.runtime.EContext;
import itez.core.runtime.service.Define;

import com.google.inject.Singleton;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class CountorServiceImpl extends EModelService<Countor> implements CountorService {

	public void access(String subDomain){
		access(subDomain, "", "");
	}

	public void access(String subDomain, String groupCode, String groupCaption){
		access(subDomain, groupCode, groupCaption, "", "");
	}
	
	public void access(String subDomain, String groupCode, String groupCaption, String pageCode, String pageCaption){
		EAttr attr = EContext.getAttr();
		Countor countor = new Countor();
		countor.setModuleCode(attr.getModuleCode());
		countor.setModuleCaption(attr.getModuleName());
		countor.setSubDomain(subDomain);
		countor.setGroupCode(groupCode);
		countor.setGroupCaption(groupCaption);
		countor.setPageCode(pageCode);
		countor.setPageCaption(pageCaption);
		countor.setBrowser(attr.getBrowser());
		countor.setBrowserVer(attr.getBrowserVer());
		countor.setIsAjax(attr.getIsAjax() ? 1 : 0);
		countor.setIsMobile(attr.getIsMobile() ? 1 : 0);
		countor.setIsWx(attr.getIsWx() ? 1 : 0);
		countor.setIsWxa(attr.getIsWxa() ? 1 : 0);
		countor.setRequestUrl(attr.getRequestUrl());
//		countor.setClient(attr.getClientIp());
//		countor.setRequestReferer(attr.getRequestReferer());
		save(countor);
	}
	
	public Integer count(String subDomain){
		return getCount(subDomain, "", "");
	}
	
	public Integer count(String subDomain, String groupCode){
		return getCount(subDomain, groupCode, "");
	}
	
	public Integer count(String subDomain, String groupCode, String pageCode){
		return getCount(subDomain, groupCode, pageCode);
	}
	
	private Integer getCount(String subDomain, String groupCode, String pageCode){
		EAttr attr = EContext.getAttr();
		Kv paras = Kv.by("domain", attr.getDomain()).set("moduleCode", attr.getModuleCode());
		paras.set("subDomain", subDomain).set("groupCode", groupCode).set("pageCode", pageCode);
		SqlPara sqlPara = dbo().getSqlPara("main.getCountor", paras);
		Record rec = dbo().findFirst(sqlPara);
		return rec.getInt("cnt");
	}

}