package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.plat.main.model.Config;
import itez.plat.main.model.ConfigDefault;
import itez.plat.main.service.ConfigDefaultService;
import itez.plat.main.service.ConfigService;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;

import java.util.List;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class ConfigServiceImpl extends EModelService<Config> implements ConfigService {

	@Inject
	ConfigDefaultService configDefService;

	@Cache.able(cache="Config", key="code")
	public ConfigDefault getByCode(String code){
		ConfigDefault def = configDefService.getByCode(code);
		if(def == null) throw new RuntimeException("参数不存在：" + code);
		Querys qs = Querys.and(Query.eq("code", code));
		Config cfg = selectFirst(qs);
		if(cfg == null){
			return def;
		}else{
			return def.setValue(cfg.getValue());
		}
	}

	@Override
	@Cache.del(cache="Config", key="code")
	public void setByCode(String code, String value) {
		Config cfg = findByCode(code);
		if(cfg == null){
			new Config().setCode(code).setValue(value).save();
		}else{
			cfg.setValue(value).update();
		}
	}

	public String getValue(String code){
		ConfigDefault def = getByCode(code);
		return def.getValue();
	}

	public Boolean getBool(String code){
		ConfigDefault def = getByCode(code);
		String type = def.getType().toLowerCase();
		String value = def.getValue();
		if(type.equals("boolean")){
			return value.equals("1");
		}else{
			return false;
		}
	}

	@Override
	public Integer getInt(String code) {
		ConfigDefault def = getByCode(code);
		String type = def.getType().toLowerCase();
		String value = def.getValue();
		if(type.equals("int")){
			return EStr.isNull(value) ? 0 : Integer.parseInt(value);
		}else{
			return 0;
		}
	}

	@Override
	@SuppressWarnings("unchecked")
	public <T> T getBy(String code) {
		String val = getValue(code);
		if(val == null) return null;
		return (T)val;
	}

	@Override
	public List<Record> getByGroup(String groupId) {
		SqlPara sql = dbo().getSqlPara("main.getConfigList", Kv.by("domain", $domain()).set("groupId", groupId));
		return dbo().find(sql);
	}

}