package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.core.runtime.service.Define;
import itez.plat.main.model.AppUpdate;
import itez.plat.main.service.AppUpdateService;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class AppUpdateServiceImpl extends EModelService<AppUpdate> implements AppUpdateService {

	@Override
	public boolean save(AppUpdate model) {
		genVerCode(model);
		return super.save(model);
	}
	
	@Override
	public boolean update(AppUpdate model) {
		genVerCode(model);
		return super.update(model);
	}
	
	@Override
	public List<AppUpdate> getApps(String appid, String os) {
		Querys qs = Querys.and(Query.eq("osType", os)).add(Query.eq("appId", appid));
		return select(qs);
	}

	@Override
	public AppUpdate chk(String appid, String os, String ver) {
		String verCode = genVerCode(ver);
		Querys qs = Querys.and(Query.eq("osType", os)).add(Query.eq("appId", appid)).add(Query.gt("appVerCode", verCode));
		return selectFirst(qs, "appVerCode desc");
	}

	private void genVerCode(AppUpdate app){
		String verStr = app.getAppVer();
		app.setAppVerCode(genVerCode(verStr));
	}
	
	private String genVerCode(String verStr){
		if(EStr.isEmpty(verStr) || verStr.indexOf(".") < 0) return verStr;
		String[] verArr = verStr.split("\\.");
		return Arrays.stream(verArr).map(v -> EStr.addPrefix(v, 3)).collect(Collectors.joining("."));
	}

}