package itez.plat.main.service;

import java.io.File;
import java.util.List;

import itez.core.runtime.service.IModelService;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.poi.XlsWriter;
import itez.plat.main.model.Dept;
import itez.plat.main.model.User;

/**
 * 由JWinner Service Generator自动生成。
 */
public interface UserService extends IModelService<User>{

	public List<User> getUsers(String ids);
	public List<User> getInsUsers(String deptId);
	public List<User> getInsUsers(String deptId, String type);
	public List<User> getInsUsersAll(String deptId);
	public List<User> getLeavedUsers(String deptId);
	public List<User> searchInsUser(String keyword);
	public List<User> searchInsUser(String keyword, String deptId);
	public List<User> searchInsUser(Querys qs);
	public void add(User user, String loginPass);
	public void modify(User user);
	public void modify(User user, String loginPass);
	public void remove(String ids);
	public void reback(String ids);
	public void move(String ids, String pidOrig, String pidTo);
	public User findByUnionId(String unionId);
	public User findByWxOpenId(String openId);
	public User findByWxaOpenId(String openId);
	public User findByWxeOpenId(String openId);
	
	public User loginByTypeName(String type, String loginName);
	public User loginByTypeNameOrIdNum(String type, String loginName);
	
	public XlsWriter export(Dept dept);
	public XlsWriter export(Dept dept, String type);
	public int imports(String deptId, File file);
	public int imports(String deptId, File file, String type, boolean multiDept);
	
	public Dept getMyDept(User user);
	public List<Dept> getMyDeptTree(User user);

}