package itez.plat.main.model;

import java.math.BigDecimal;
import java.util.stream.Collectors;

import com.jfinal.kit.HashKit;

import itez.core.runtime.service.Ioc;
import itez.core.runtime.service.common.IUser;
import itez.core.runtime.service.common.IUserService;
import itez.kit.EStr;
import itez.plat.main.model.base.BaseUser;
import itez.plat.main.service.DeptService;
import itez.plat.main.service.PostLevelService;
import itez.plat.main.service.PostService;
import itez.plat.main.service.RoleService;
import itez.plat.main.service.VertService;

/**
 * 由JWinner Model Generator自动生成。
 */
@SuppressWarnings("serial")
public class User extends BaseUser<User> implements IUser {
	
	private transient final IUserService us = Ioc.getUser();
	private transient final DeptService ds = Ioc.get(DeptService.class);
	private transient final PostService ps = Ioc.get(PostService.class);
	private transient final PostLevelService pls = Ioc.get(PostLevelService.class);
	private transient final VertService vs = Ioc.get(VertService.class);
	private transient final RoleService rs = Ioc.get(RoleService.class);

	/**
	 * 实现几个扩展方法，便于通过人员对象获取更多信息
	 */

	public Dept getDept(){
		if(getDeptId() == null) return null;
		return ds.findById(getDeptId());
	}
	
	public Post getPost(){
		if(super.getPostId() == null) return null;
		Post post = ps.findById(getPostId());
		return post;
	}
	
	public PostLevel getPostLevel(){
		Post post = getPost();
		if(post == null) return null;
		String plevelId = post.getLevelId();
		if(plevelId == null) return null;
		PostLevel plevel = pls.findById(plevelId);
		return plevel;
	}
	
	public Vert getVert(){
		PostLevel plevel = getPostLevel();
		if(plevel == null) return null;
		String vertId = plevel.getVertId();
		if(vertId == null) return null;
		Vert vert = vs.findById(vertId);
		return vert;
	}

	/**
	 * 重写两个属性取值
	 * 1、系数：默认取个人系数，为空时取岗位系数
	 * 2、角色：默认取个人角色，为空时取岗位角色
	 */
	
	@Override
	public BigDecimal getCoef() {
		if(super.getCoef() != null) return super.getCoef();
		Post post = getPost();
		if(post == null) return null;
		return post.getCoef();
	}
	
	@Override
	public String getRoleIds() {
		if(getLevel() == 2) return rs.getAll().stream().map(r -> r.getCode()).collect(Collectors.joining(","));
		if(super.getRoleIds() != null) return super.getRoleIds();
		Post post = getPost();
		if(post == null) return null;
		return post.getRoleIds();
	}

	@Override
	public boolean checkPass(String password) {
		if(EStr.isEmpty(this.getLoginPass())) return false;
		if(EStr.isEmpty(password)) return false;
		String passCode = HashKit.md5(password.concat(this.getSalt()));
		return this.getLoginPass().equals(passCode);
	}
	
	/**
	 * 在Model中实现鉴权方法
	 * 
	 * 主要为了实现视图模板中的鉴权需求
	 * 
	 * 模板中鉴权方法：
	 * 
	 *   #if(session.user.checkRole("...")) ...
	 */
	
	@Override
	public boolean checkRole(String roleCode) {
		return us.checkRole(this, roleCode);
	}

	@Override
	public boolean checkRoles(String... roleCodeArr) {
		return us.checkRoles(this, roleCodeArr);
	}

	@Override
	public boolean checkRolesAny(String... roleCodeArr) {
		return us.checkRolesAny(this, roleCodeArr);
	}

	@Override
	public boolean checkPerm(String permCode) {
		return us.checkPerm(this, permCode);
	}

	@Override
	public boolean checkPerms(String... permCodeArr) {
		return us.checkPerms(this, permCodeArr);
	}

	@Override
	public boolean checkPermsAny(String... permCodeArr) {
		return us.checkPermsAny(this, permCodeArr);
	}
	
	
}
