/**
 * WxOplatController.java
 */
package itez.plat.main.controller;

import com.jfinal.aop.Before;

import itez.core.launch.JW;
import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.controller.EController;
import itez.kit.ECode;
import itez.kit.EStr;
import itez.kit.EWeb;
import itez.kit.restful.Result;
import itez.plat.wrapper.interceptor.WxOplatInterceptor;
import itez.weixin.api.ApiConfigKit;
import itez.weixin.oplat.AccessToken;
import itez.weixin.oplat.AccessTokenApi;
import itez.weixin.oplat.ApiResult;
import itez.weixin.oplat.UserInfoApi;

/**
 * <p>
 * 微信开放平台单点登录（OAUTH）
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年6月30日 下午3:29:35
 */
@Before(WxOplatInterceptor.class)
@ControllerDefine(key = "/wxoplat", summary = "微信开放平台", view = "/")
public class WxOplatController extends EController {

	/**
	 * <p>
	 * 返回appid
	 * </p>
	 *
	 */
	public void getAppId(){
		String appid = ApiConfigKit.getApiConfig().getAppId();
		renderJson(Result.success("appid",appid ));
	}
	
	/**
	 * <p>
	 * 跳转到微信授权页面：非微信环境显示二维码；否则直接唤起授权弹窗
	 * </p>
	 *
	 */
	public void oauth(String state){
		String urlTemp = getAttr("authUrl");
		String appid = ApiConfigKit.getApiConfig().getAppId();
		String redirect = EWeb.UrlEncoder(attr().getCtrl());
		String url = String.format(urlTemp, appid, redirect, state);
		redirect(url);
	}
	
	/**
	 * <p>
	 * 授权回调
	 * </p>
	 * 
	 * @param code
	 * @param state
	 */
	public void index(String code, String state){
		if(EStr.isEmpty(code)){
			renderText("未发现有效的code");
			return;
		}
		
		AccessToken accessTokenObj = AccessTokenApi.getAccessToken(code);
		if(accessTokenObj == null || !accessTokenObj.isAvailable()){
			renderText("获取access_token时发生错误");
			return;
		}
		
		String accessToken = accessTokenObj.getAccessToken();
		String openid = accessTokenObj.getOpenid();
		
		ApiResult ret = UserInfoApi.getUserInfo(accessToken, openid);
		if(ret == null || !ret.isSucceed()){
			renderText("获取用户信息时发生错误");
			return;
		}
	
		if(EStr.isEmpty(state) || !state.startsWith("http")){
			renderText("未发现有效的回调地址");
			return;
		}
		
		String callback = EWeb.UrlDecoder(state);
		redirect(callback.concat("?data=") + ECode.AESEncode(ret.getJson(), JW.SecurityKey));
	}
	
}
