package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;
import com.jfinal.core.paragetter.Para;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EProp;
import itez.plat.main.model.Task;
import itez.plat.main.service.TaskService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/task", summary = "定时任务管理", view = "/")
public class TaskController extends EControllerMgr {

	@Inject
	TaskService taskSer;
	
	public void index(){
		List<Task> tasks = taskSer.selectAll();
		setAttr("enable", EProp.EnableCronTask);
		setAttr("tasks", tasks);
		render("task.html");
	}
	
	public void add(@Para("")Task task){
		taskSer.save(task);
		redirect(attr().getCtrl());
	}
	
	public void modify(@Para("")Task task){
		taskSer.update(task);
		redirect(attr().getCtrl());
	}
	
	public void remove(String id){
		taskSer.deleteById(id);
		redirect(attr().getCtrl());
	}
	
	public void play(String id){
		taskSer.enableTask(id);
		redirect(attr().getCtrl());
	}
	
	public void stop(String id){
		taskSer.disableTask(id);
		redirect(attr().getCtrl());
	}
	
}
