package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.plat.main.model.Module;
import itez.plat.main.model.Perm;
import itez.plat.main.model.Role;
import itez.plat.main.service.ModuleService;
import itez.plat.main.service.PermService;
import itez.plat.main.service.RoleService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/auth/role", summary = "角色管理", view = "/auth")
public class RoleController extends EControllerMgr {
	
	@Inject
	RoleService roleSer;
	
	@Inject
	PermService permSer;
	
	@Inject
	ModuleService moduleSer;

	public void index(String moduleCode){
		List<Module> modules = moduleSer.selectAll();
		if(EStr.isEmpty(moduleCode)) moduleCode = modules.get(0).getCode();
		List<Perm> perms = permSer.getByModule(moduleCode);
		List<Role> list = roleSer.getByModule(moduleCode);
		setAttr("moduleCode", moduleCode);
		setAttr("list", EJson.toJson(list));
		setAttr("perms", EJson.toJson(perms));
		setAttr("modules", EJson.toJson(modules));
		render("role.html");
	}
	
	public void form(String moduleCode, String id){
		Role role = EStr.isEmpty(id) ? new Role().setModuleId(moduleCode) : roleSer.findById(id);
		List<Perm> perms = permSer.getByModule(moduleCode);
		setAttr("addMode", EStr.isEmpty(id));
		setAttr("model", EJson.toJson(role));
		setAttr("perms", EJson.toJson(perms));
		render("role-form.html");
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		Role role = paras.getModel(Role.class);
		role.setPermIds(EStr.parseArray(paras.getValues("permIds")));
		if(EStr.isEmpty(role.getId())) roleSer.save(role);
		else roleSer.update(role);
		redirect(attr().getCtrl().concat("?moduleCode=").concat(role.getModuleId()));
	}
	
	public void remove(String moduleCode, String id){
		roleSer.deleteById(id);
		redirect(attr().getCtrl().concat("?moduleCode=").concat(moduleCode));
	}
	
}
