package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.plat.main.model.Module;
import itez.plat.main.model.Perm;
import itez.plat.main.service.ModuleService;
import itez.plat.main.service.PermService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/auth/perm", summary = "权限管理", view = "/auth")
public class PermController extends EControllerMgr {
	
	@Inject
	PermService permSer;
	
	@Inject
	ModuleService moduleSer;

	public void index(String moduleCode){
		List<Module> modules = moduleSer.selectAll();
		if(EStr.isEmpty(moduleCode)) moduleCode = modules.get(0).getCode();
		List<Perm> list = permSer.getByModule(moduleCode);
		setAttr("moduleCode", moduleCode);
		setAttr("list", EJson.toJson(list));
		setAttr("modules", EJson.toJson(modules));
		render("perm.html");
	}
	
	public void form(String moduleCode, String id){
		Perm perm = EStr.isEmpty(id) ? new Perm().setModuleId(moduleCode) : permSer.findById(id);
		setAttr("addMode", EStr.isEmpty(id));
		setAttr("model", EJson.toJson(perm));
		render("perm-form.html");
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		Perm perm = paras.getModel(Perm.class);
		if(EStr.isEmpty(perm.getId())) permSer.save(perm);
		else permSer.update(perm);
		redirect(attr().getCtrl().concat("?moduleCode=").concat(perm.getModuleId()));
	}
	
	public void remove(String moduleCode, String id){
		permSer.deleteById(id);
		redirect(attr().getCtrl().concat("?moduleCode=").concat(moduleCode));
	}
	
}
