package itez.plat.main.controller;

import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.inject.Inject;
import com.jfinal.aop.Before;
import com.jfinal.ext.interceptor.POST;
import com.jfinal.plugin.activerecord.Record;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.ERet;
import itez.kit.EStr;
import itez.kit.EUid;
import itez.kit.pay.PayBase;
import itez.kit.pay.PayKit;
import itez.kit.pay.PayKit.Channel;
import itez.plat.main.model.PaymentChannel;
import itez.plat.main.service.PaymentChannelService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/payment", summary = "支付渠道设置", view = "/")
public class PaymentController extends EControllerMgr {

	private final static String PAY_DEBUG_SESSION_CODE = "PAY_DEBUG_SESSION_CODE";
	private final static String PAY_DEBUG_SESSION_RET = "PAY_SESSION_RET";

	@Inject
	PaymentChannelService paySer;
	
	public void index(String code){
		List<Record> channels = paySer.getPaymentChannels();
		if(EStr.isEmpty(code)) code = channels.get(0).getStr("code");
		PayKit.Channel channel = Channel.valueOf(code);
		PaymentChannel payment = paySer.findByCode(code);
		if(payment == null) payment = new PaymentChannel().setCode(code).setCaption(channel.getCaption()).setEnable(0);
		String params = payment.getParams();
		setAttr("paramConfig", PayKit.me.paramConfig(channel));
		setAttr("channels", EJson.toJson(channels));
		setAttr("payment", EStr.isEmpty(params) ? EJson.toJson(payment) : JSON.parseObject(params));
		render("payment.html");
	}
	
	public void formEvent(){
		String code = get("code");
		String caption = get("caption");
		Integer enable = getInt("enable");
		PaymentChannel payment = paySer.findByCode(code);
		String params = EJson.toJson(getParaData());
		if(payment == null) payment = new PaymentChannel();
		payment.setCode(code).setCaption(caption).setEnable(enable).setParams(params).setSort(0).saveOrUpdate();
		redirect(attr().getCtrl().concat("?code=").concat(code));
	}
	
	public void debug(String code){
		String errMsg = "";
		String qrCode = "";
		String orderId = "DEBUG_".concat(EUid.generator()); //订单号
		String payment = "0.01"; //一分钱
		List<Record> channels = paySer.getPaymentChannels();
		if(EStr.isEmpty(code)) code = channels.get(0).getStr("code");
		session().setAttribute(PAY_DEBUG_SESSION_CODE, code);
		
		PaymentChannel payModel = paySer.findByCode(code);
		if(payModel == null || EStr.isEmpty(payModel.getParams())){
			errMsg = "请先将支付渠道相关参数设置完成";
		}else{
			JSONObject configs = JSON.parseObject(payModel.getParams());
			try {
				qrCode = PayKit.me.getQrCode(configs, orderId, payment, "", "");
			} catch (Exception e) {
				errMsg = e.getMessage();
			}
		}
		setAttr("channels", EJson.toJson(channels));
		setAttr("code", code);
		setAttr("qrCode", qrCode);
		setAttr("errMsg", errMsg);
		setAttr("orderId", orderId);
		render("payment-debug.html");
	}
	
	public void debugQr(String qrCode){
		renderQrCode(qrCode, 200, 200);
	}
	
	public void vali(String orderId){
		ERet ret = session().getAttr(PAY_DEBUG_SESSION_RET);
		if(ret == null){
			renderJson(ERet.fail());
			return;
		}
		String retOrder = ret.getStr(PayBase.PAYMENT_ORDER_ID);
		if(EStr.notEmpty(retOrder) && orderId.equals(retOrder)) renderJson(ERet.ok().set("ret", ret));
		else renderJson(ERet.fail());
	}

	@AuthRequire.Guest
	@Before(POST.class)
	public void callback(){
		String code = session().getAttr(PAY_DEBUG_SESSION_CODE);
		PaymentChannel payModel = paySer.findByCode(code);
		JSONObject configs = JSON.parseObject(payModel.getParams());
		EPara paras = paramPack();
		ERet ret = PayKit.me.callback(configs, paras);
		session().setAttribute(PAY_DEBUG_SESSION_RET, ret);
		renderNull();
	}
	
}
