package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;
import com.jfinal.kit.Kv;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.ERet;
import itez.kit.EStr;
import itez.plat.main.model.Menu;
import itez.plat.main.service.MenuService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/menu", summary = "菜单管理", view = "/")
@AuthRequire.Logined
public class MenuController extends EControllerMgr {
	
	@Inject
	MenuService menuSer;
	
	public void index(){
		String mtype = getPara("mtype", "menu");
		String title = mtype.equals("menu") ? "侧栏菜单" : "顶栏导航";
		Kv rootMenu = Kv.by("id", "").set("caption", title).set("folder", 1);
		List<Menu> menus = menuSer.getMenuTree(mtype);
		setAttr("mtype", mtype);
		setAttr("title", title);
		setAttr("pid", getPara("pid", null));
		setAttr("rootMenu", rootMenu);
		setAttr("menus", menus);
		render("menu.html");
	}
	
	public void init(){
		String mtype = getPara("mtype", "menu");
		String module = getPara("module", "module");
		try {
			menuSer.init(mtype, module);
			renderJson(ERet.ok());
		} catch (Exception e) {
			renderJson(ERet.fail(e.getMessage()));
		}
	}
	
	public void add(){
		String mtype = getPara("mtype", "menu");
		String pid = getPara("pid");
		
		String ico = getPara("ico");
		String caption = getPara("caption");
		String command = getPara("command");
		String authMode = getPara("authMode");
		String authCode = getPara("authCode");
		Integer folder = getParaToInt("folder", 0);
		if(EStr.notNull(authMode) && authMode.equals("-")) authMode = null;
		if(EStr.isEmpty(pid)) pid = null;

		Menu parent = EStr.isEmpty(pid) ? null : menuSer.findById(pid);
		Menu last = menuSer.getLastMenu(mtype, pid);
		Integer sort = last == null ? 1 : last.getSort() + 1;
		String path = parent == null ? EStr.addPrefix(sort, 3) : String.format("%s_%s", parent.getPath(), EStr.addPrefix(sort, 3));
		Menu menu = new Menu();
		menu.setMtype(mtype);
		menu.setPid(pid);
		menu.setIco(ico);
		menu.setCaption(caption);
		menu.setCommand(command);
		menu.setAuthMode(authMode);
		menu.setAuthCode(authCode);
		menu.setFolder(folder);
		menu.setSort(sort);
		menu.setPath(path);
		menuSer.save(menu);
		redirect(attr().getCtrl() + "?mtype=" + mtype + "&pid=" + EStr.ifEmpty(pid, ""));
	}
	
	public void modify(){
		String id = getPara("id");
		Menu menu = menuSer.findById(id);
		String mtype = menu.getMtype();
		String pid = menu.getPid();

		String ico = getPara("ico");
		String caption = getPara("caption");
		String command = getPara("command");
		String authMode = getPara("authMode");
		String authCode = getPara("authCode");
		Integer folder = getParaToInt("folder", 0);
		if(EStr.notNull(authMode) && authMode.equals("-")) authMode = null;

		menu.setIco(ico);
		menu.setCaption(caption);
		menu.setCommand(command);
		menu.setAuthMode(authMode);
		menu.setAuthCode(authCode);
		menu.setFolder(folder);
		
		menuSer.update(menu);
		redirect(attr().getCtrl() + "?mtype=" + mtype + "&pid=" + pid);
	}
	
	public void remove(){
		String mtype = getPara("mtype", "menu");
		String pid = getPara("pid");
		String ids = getPara("ids");
		menuSer.deleteByIds(ids);
		redirect(attr().getCtrl() + "?mtype=" + mtype + "&pid=" + pid);
	}
	
	public void sort(){
		String mtype = getPara("mtype", "menu");
		String pid = getPara("pid");
		String opt = getPara("opt");
		String ids = getPara("ids");
		menuSer.sort(mtype, pid, opt, ids);
		redirect(attr().getCtrl() + "?mtype=" + mtype + "&pid=" + pid);
	}

}
