package itez.plat.main.controller;

import java.io.File;
import java.util.List;

import com.google.common.collect.Lists;
import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.runtime.service.common.IUser;
import itez.core.runtime.service.common.IUserService;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.kit.poi.XlsWriter;
import itez.plat.main.model.Dept;
import itez.plat.main.model.Role;
import itez.plat.main.model.User;
import itez.plat.main.service.DeptService;
import itez.plat.main.service.RoleService;
import itez.plat.main.service.UserService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/insUser", summary = "成员管理", view = "/")
@AuthRequire.Logined
public class InsUserController extends EControllerMgr {

	@Inject
	UserService us;

	@Inject
	IUserService userSer;
	
	@Inject
	DeptService ds;
	
	@Inject
	RoleService rs;
	
	public void index(String pid, String type){
		User user = (User)session().getUser();
		Dept rootDept = us.getMyDept(user);
		List<Dept> depts = us.getMyDeptTree(user);
		String roleIds = user.getRoleIds();
		List<Role> roles = Lists.newArrayList();
		if(EStr.notEmpty(roleIds)) roles = rs.findByCodes(roleIds);
		if(EStr.isEmpty(pid)) pid = rootDept.getId();
		List<User> users = us.getInsUsers(pid, type);
		setAttr("pid", pid);
		setAttr("type", type);
		setAttr("rootDept", EJson.toJsonFilter(rootDept, "id", "caption", "path"));
		setAttr("depts", EJson.toJsonFilter(depts, "id", "caption", "path"));
		setAttr("users", EJson.toJson(users));
		setAttr("roles", EJson.toJsonFilter(roles, "code", "caption"));
		render("insUser.html");
	}
	
	public void add(String pid, String type){
		User user = new User().setType(type).setDeptId(pid);
		User me = (User)session().getUser();
		String roleIds = me.getRoleIds();
		List<Role> roles = Lists.newArrayList();
		if(EStr.notEmpty(roleIds)) roles = rs.findByCodes(roleIds);
		setAttr("user", EJson.toJson(user));
		setAttr("roles", EJson.toJsonFilter(roles, "code", "caption"));
		render("insUserAdd.html");
	}
	
	public void addEvent(){
		String domain = attr().getDomain();
		String pid = getPara("deptId");
		String type = getPara("type");
		String caption = getPara("caption");
		String loginName = getPara("loginName");
		String loginPass = getPara("loginPass", loginName);
		String roleIds = EStr.parseArray(getParaValues("roleIds"));
		String idNum = getPara("idNum");
		String phone = getPara("phone");
		String email = getPara("email");
		String sex = getPara("sex");

		IUser exist = userSer.findByLogin(domain, loginName);
		if(exist != null){
			setFlashMsg("添加失败，登录账号已存在！");
			redirect(attr().getCtrl() + "?pid=" + pid + "&type=" + type);
			return;
		}
		if(EStr.notEmpty(idNum)){
			exist = userSer.findByIdNum(domain, idNum);
			if(exist != null){
				setFlashMsg("添加失败，身份证号已存在！");
				redirect(attr().getCtrl() + "?pid=" + pid + "&type=" + type);
				return;
			}
		}
		if(EStr.notEmpty(phone)){
			exist = userSer.findByPhone(domain, phone);
			if(exist != null){
				setFlashMsg("添加失败，手机号已存在！");
				redirect(attr().getCtrl() + "?pid=" + pid + "&type=" + type);
				return;
			}
		}
		if(EStr.notEmpty(email)){
			exist = userSer.findByEmail(domain, email);
			if(exist != null){
				setFlashMsg("添加失败，Email已存在！");
				redirect(attr().getCtrl() + "?pid=" + pid + "&type=" + type);
				return;
			}
		}
		
		User user = new User();
		user.setDomain(attr().getDomain());
		user.setMember(1);
		user.setType(type);
		user.setCaption(caption);
		user.setLoginName(loginName);
		user.setLevel(0);
		user.setRoleIds(roleIds);
		user.setDeptId(pid);
		user.setIdNum(idNum);
		user.setPhone(phone);
		user.setEmail(email);
		user.setSex(sex);
		us.add(user, loginPass);
		redirect(attr().getCtrl() + "?pid=" + pid + "&type=" + type);
	}
	
	public void modify(String id, String type){
		User user = us.findById(id);
		User me = (User)session().getUser();
		String roleIds = me.getRoleIds();
		List<Role> roles = Lists.newArrayList();
		if(EStr.notEmpty(roleIds)) roles = rs.findByCodes(roleIds);
		setAttr("utype", type);
		setAttr("user", EJson.toJson(user.remove("loginPass", "salt")));
		setAttr("roles", EJson.toJsonFilter(roles, "code", "caption"));
		render("insUserModify.html");
	}
	
	public void modifyEvent(){
		String domain = attr().getDomain();
		String pid = getPara("deptId");
		String type = getPara("utype");
		String id = getPara("id");
		String caption = getPara("caption");
		String loginName = getPara("loginName");
		String loginPass = getPara("loginPass");
		String roleIds = EStr.parseArray(getParaValues("roleIds"));
		String idNum = getPara("idNum");
		String phone = getPara("phone");
		String email = getPara("email");
		String sex = getPara("sex");

		IUser exist = userSer.findByLogin(domain, loginName);
		if(exist != null && !exist.getId().equals(id)){
			setFlashMsg("修改失败，登录账号已存在！");
			redirect(attr().getCtrl() + "?pid=" + pid + "&type=" + type);
			return;
		}
		if(EStr.notEmpty(idNum)){
			exist = userSer.findByIdNum(domain, idNum);
			if(exist != null && !exist.getId().equals(id)){
				setFlashMsg("修改失败，身份证号已存在！");
				redirect(attr().getCtrl() + "?pid=" + pid + "&type=" + type);
				return;
			}
		}
		if(EStr.notEmpty(phone)){
			exist = userSer.findByPhone(domain, phone);
			if(exist != null && !exist.getId().equals(id)){
				setFlashMsg("修改失败，手机号已存在！");
				redirect(attr().getCtrl() + "?pid=" + pid + "&type=" + type);
				return;
			}
		}
		if(EStr.notEmpty(email)){
			exist = userSer.findByEmail(domain, email);
			if(exist != null && !exist.getId().equals(id)){
				setFlashMsg("修改失败，Email已存在！");
				redirect(attr().getCtrl() + "?pid=" + pid + "&type=" + type);
				return;
			}
		}
		
		User user = (User) us.findById(id);
		user.setCaption(caption);
		user.setLoginName(loginName);
		user.setRoleIds(roleIds);
		user.setIdNum(idNum);
		user.setPhone(phone);
		user.setEmail(email);
		user.setSex(sex);
		if(EStr.notEmpty(loginPass)) us.modify(user, loginPass);
		us.modify(user);
		redirect(attr().getCtrl() + "?pid=" + pid + "&type=" + type);
	}
	
	public void remove(String pid, String type, String ids){
		us.remove(ids);
		redirect(attr().getCtrl() + "?pid=" + pid + "&type=" + EStr.ifEmpty(type, ""));
	}
	
	public void move(String pidOrig, String pid, String ids, String type){
		us.move(ids, pidOrig, pid);
		redirect(attr().getCtrl() + "?pid=" + pid + "&type=" + EStr.ifEmpty(type, ""));
	}
	
	public void exports(String deptId, String type){
		Dept dept;
		if(EStr.notEmpty(deptId)){
			dept = ds.findById(deptId);
		}else{
			dept = us.getMyDept((User)session().getUser());
		}
		XlsWriter xls = us.export(dept, type);
		render(xls);
	}
	
	public void imports(String deptId, String type){
		Dept dept = ds.findById(deptId);
		setAttr("dept", dept);
		setAttr("type", type);
		render("insUserImports.html");
	}
	
	public void importsEvent(){
		EPara paras = paramPack(false);
		String deptId = paras.get("deptId");
		String type = paras.get("type");
		boolean multiDept = paras.get("multiDept", "").equals("ok");
		File file = paras.getFileObj("file");
		try {
			int cnt = us.imports(deptId, file, type, multiDept);
			setFlashMsg("导入成功，共导入 " + cnt + " 条成员信息。");
			redirect(attr().getCtrl() + "?pid=" + deptId + "&type=" + type);
		} catch (Exception e) {
			setFlashMsg("导入失败，" + e.getMessage());
			redirect(attr().getCtrl() + "/imports?deptId=" + deptId + "&type=" + type);
		}
	}
	
}
