package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.plat.main.model.DictGroup;
import itez.plat.main.service.DictGroupService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/dictGroup", summary = "字典分组管理", view = "/")
public class DictGroupController extends EControllerMgr {

	@Inject
	DictGroupService dictGroupService;
	
	public void index(){
		List<DictGroup> groups = dictGroupService.selectAll();
		setAttr("groups", groups);
		render("dictGroup.html");
	}
	
	public void add(){
		DictGroup group = getBean(DictGroup.class, "");
		DictGroup exist = dictGroupService.findByCode(group.getCode());
		if(exist != null){
			setFlashMsg("保存失败，别名[" + group.getCode() + "]已存在！");
			redirect(attr().getCtrl());
			return;
		}
		dictGroupService.save(group);
		redirect(attr().getCtrl());
	}
	
	public void modify(){
		DictGroup group = getBean(DictGroup.class, "");
		dictGroupService.update(group);
		redirect(attr().getCtrl());
	}
	
	public void remove(String ids){
		dictGroupService.deleteByIds(ids);
		redirect(attr().getCtrl());
	}

}
