package itez.plat.main.controller;

import com.google.inject.Inject;
import com.jfinal.plugin.activerecord.Page;

import itez.core.runtime.auth.AuthCode;
import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EStr;
import itez.plat.main.model.Dict;
import itez.plat.main.model.DictGroup;
import itez.plat.main.service.DictGroupService;
import itez.plat.main.service.DictService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/dict", summary = "字典管理", view = "/")
public class DictController extends EControllerMgr {

	@Inject
	DictService dictService;

	@Inject
	DictGroupService dictGroupService;
	
	public void index(){
		String code = getPara("code");
		Integer pageNumber = getParaToInt("page", 1);
		if(EStr.isEmpty(code)){
			renderErrHelp(AuthCode.LOGIC, "未接收到有效到字典目录别名！", attr().getModuleUrl() + "/dictGroup");
			return;
		}
		DictGroup group = dictGroupService.findByCode(code);
		Page<Dict> dicts = dictService.getPageByGroup(code, pageNumber);
		setAttr("group", group);
		setAttr("dicts", dicts);
		render("dict.html");
	}
	
	public void add(){
		String code = getPara("code");
		Dict dict = getBean(Dict.class, "");
		dict.setGroupCode(code);
		dictService.save(dict);
		redirect(attr().getCtrl() + "?code=" + code);
	}
	
	public void modify(){
		String code = getPara("code");
		Dict dict = getBean(Dict.class, "");
		dictService.update(dict);
		redirect(attr().getCtrl() + "?code=" + code);
	}
	
	public void remove(String ids){
		String code = getPara("code");
		dictService.deleteByIds(ids);
		redirect(attr().getCtrl() + "?code=" + code);
	}
	
}
