package itez.plat.main.controller;

import java.io.File;
import java.util.List;

import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.plat.main.model.Dept;
import itez.plat.main.model.User;
import itez.plat.main.service.DeptService;
import itez.plat.main.service.UserService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/dept", summary = "部门管理", view = "/")
@AuthRequire.Logined
public class DeptController extends EControllerMgr {

	@Inject
	DeptService deptSer;
	
	@Inject
	UserService userSer;
	
	public void index(String pid){
		User user = (User)session().getUser();
		Dept deptRoot = userSer.getMyDept(user);
		Dept deptCurr = EStr.isEmpty(pid) ? deptRoot : deptSer.findById(pid);
		pid = deptCurr.getId();
		List<Dept> deptTree = userSer.getMyDeptTree(user);
		List<Dept> depts = deptSer.getSubDepts(pid);
		setAttr("pid", pid);
		setAttr("deptRoot", EJson.toJson(deptRoot));
		setAttr("deptCurr", EJson.toJson(deptCurr));
		setAttr("deptTree", EJson.toJson(deptTree));
		setAttr("depts", EJson.toJson(depts));
		render("dept.html");
	}
	
	public void form(String pid, String id){
		Dept dept = EStr.isEmpty(id) ? new Dept().setPid(pid) : deptSer.findById(id);
		setAttr("dept", EJson.toJson(dept));
		render("deptForm.html");
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		Dept dept = paras.getModel(Dept.class);
		String pid = dept.getPid();
		if(EStr.isEmpty(dept.getId())){
			Dept parent = deptSer.findById(pid);
			Dept last = deptSer.getLastDept(pid);
			Integer sort = last == null ? 1 : last.getSort() + 1;
			String path = String.format("%s_%s", parent.getPath(), EStr.addPrefix(sort, 3));
			dept.setSort(sort);
			dept.setPath(path);
			deptSer.addDept(dept);
		}else{
			deptSer.modifyDept(dept);
		}
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
	public void remove(String pid, String ids){
		deptSer.removeDepts(ids);
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
	public void sort(String pid, String opt, String ids){
		deptSer.sort(pid, opt, ids);
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
	public void imports(String pid){
		Dept parentDept = deptSer.findById(pid);
		setAttr("parentDept", parentDept.keep("id", "caption"));
		render("deptImports.html");
	}
	
	public void importsEvent(){
		EPara paras = paramPack(false);
		String deptId = paras.get("deptId");
		File file = paras.getFileObj("file");
		try {
			int cnt = deptSer.imports(deptId, file);
			setFlashMsg("导入成功，共导入 " + cnt + " 条部门信息。");
			redirect(attr().getCtrl() + "?pid=" + deptId);
		} catch (Exception e) {
			setFlashMsg("导入失败，" + e.getMessage());
			redirect(attr().getCtrl() + "/imports?pid=" + deptId);
		}
	}
	
}
