package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.plat.main.model.ConfigGroup;
import itez.plat.main.service.ConfigGroupService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/config/group", summary = "系统参数分组配置", view = "/config")
public class ConfigGroupCongroller extends EControllerMgr {

	@Inject
	ConfigGroupService groupSer;
	
	public void index(){
		List<ConfigGroup> groups = groupSer.selectAll();
		setAttr("list", EJson.toJson(groups));
		render("group.html");
	}
	
	public void form(String id){
		ConfigGroup model = EStr.isEmpty(id) ? new ConfigGroup() : groupSer.findById(id);
		setAttr("model", EJson.toJson(model));
		render("group-form.html");
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		ConfigGroup model = paras.getModel(ConfigGroup.class);
		groupSer.saveOrUpdate(model);
		redirect(attr().getCtrl());
	}
	
	public void remove(String id){
		groupSer.disable(id);
		redirect(attr().getCtrl());
	}
	
}
