package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.plat.main.model.ConfigDefault;
import itez.plat.main.model.ConfigGroup;
import itez.plat.main.service.ConfigDefaultService;
import itez.plat.main.service.ConfigGroupService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/config/def", summary = "系统参数默认值", view = "/config")
public class ConfigDefaultController extends EControllerMgr {

	@Inject
	ConfigGroupService groupSer;
	
	@Inject
	ConfigDefaultService defSer;
	
	public void index(String groupId){
		List<ConfigGroup> groups = groupSer.selectAll();
		if(EStr.isEmpty(groupId)) groupId = groups.get(0).getId();
		List<ConfigDefault> defs = defSer.getByGroup(groupId);
		setAttr("groupId", groupId);
		setAttr("groups", EJson.toJson(groups));
		setAttr("defs", EJson.toJson(defs));
		render("defs.html");
	}
	
	public void form(String groupId, String id){
		ConfigDefault model = EStr.isEmpty(id) ? new ConfigDefault().setGroupId(groupId) : defSer.findById(id);
		setAttr("addMode", EStr.isEmpty(id));
		setAttr("model", EJson.toJson(model));
		render("defs-form.html");
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		ConfigDefault model = paras.getModel(ConfigDefault.class);
		defSer.saveOrUpdate(model);
		redirect(attr().getCtrl().concat("?groupId=").concat(model.getGroupId()));
	}
	
	public void remove(String groupId, String id){
		defSer.disable(id);
		redirect(attr().getCtrl().concat("?groupId=").concat(groupId));
	}
	
}
