package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;
import com.jfinal.plugin.activerecord.Record;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.plat.main.model.ConfigDefault;
import itez.plat.main.model.ConfigGroup;
import itez.plat.main.service.ConfigGroupService;
import itez.plat.main.service.ConfigService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/config/setting", summary = "系统参数设置", view = "/config")
public class ConfigController extends EControllerMgr {

	@Inject
	ConfigGroupService groupSer;
	
	@Inject
	ConfigService cfgSer;
	
	public void index(String groupId){
		List<ConfigGroup> groups = groupSer.selectAll();
		if(EStr.isEmpty(groupId)) groupId = groups.get(0).getId();
		List<Record> cfgs = cfgSer.getByGroup(groupId);
		setAttr("groupId", groupId);
		setAttr("groups", EJson.toJson(groups));
		setAttr("cfgs", EJson.toJson(cfgs));
		render("values.html");
	}
	
	public void form(String groupCode){
		ConfigDefault model = cfgSer.getByCode(groupCode);
		setAttr("model", EJson.toJson(model));
		render("values-form.html");
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		ConfigDefault model = paras.getModel(ConfigDefault.class);
		cfgSer.setByCode(model.getCode(), model.getValue());
		redirect(attr().getCtrl().concat("?groupId=").concat(model.getId()));
	}
	
}
