package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.plat.main.model.Comp;
import itez.plat.main.model.Module;
import itez.plat.main.service.CompService;
import itez.plat.main.service.ModuleService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/comp/mgr", summary = "租户管理", view = "/comp")
public class CompMgrController extends EControllerMgr {

	@Inject
	CompService compSer;
	
	@Inject
	ModuleService moduleSer;
	
	public void index(){
		List<Comp> list = compSer.getAllComp();
		List<Module> modules = moduleSer.selectAll();
		setAttr("list", EJson.toJson(list));
		setAttr("modules", EJson.toJson(modules));
		setAttr("domainTemp", EProp.DomainTemplate);
		render("list.html");
	}
	
	public void form(String id){
		Comp comp = EStr.isEmpty(id) ? new Comp() : compSer.findById(id);
		List<Module> modules = moduleSer.selectAll();
		setAttr("model", EJson.toJson(comp));
		setAttr("modules", EJson.toJson(modules));
		setAttr("addMode", EStr.isEmpty(id));
		render("form.html");
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		Comp comp = paras.getModel(Comp.class);
		comp.setPid(attr().getCompDef().getId());
		compSer.saveOrUpdate(comp);
		redirect(attr().getCtrl());
	}
	
	public void remove(String id){
		compSer.disableByIda(id);
		redirect(attr().getCtrl());
	}
	
}
