package itez.plat.main.controller;

import com.google.inject.Inject;
import com.jfinal.upload.UploadFile;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EStr;
import itez.plat.main.model.Comp;
import itez.plat.main.service.CompService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/comp", summary = "单位管理", view = "/")
public class CompController extends EControllerMgr {
	
	@Inject
	CompService compSer;

	public void index(){
		render("comp.html");
	}
	
	public void modify(){
		UploadFile logoMiniFile = getFile("logoMiniFile");
		String logoMini = logoMiniFile != null ? getUpload(logoMiniFile.getFile()) : "";
		UploadFile logoFullFile = getFile("logoFullFile");
		String logoFull = logoFullFile != null ? getUpload(logoFullFile.getFile()) : "";
		UploadFile wechatFile = getFile("wechatFile");
		String wechat = wechatFile != null ? getUpload(wechatFile.getFile()) : "";
		
		Comp compForm = getBean(Comp.class, "");
		Comp comp = (Comp)attr().getComp();
		comp._setAttrs(compForm);
		if(EStr.notEmpty(logoMini)) comp.setLogoMini(logoMini);
		if(EStr.notEmpty(logoFull)) comp.setLogoFull(logoFull);
		if(EStr.notEmpty(wechat)) comp.setWechat(wechat);
		compSer.update(comp);
		
		redirect(attr().getCtrl());
	}
	
}
