package itez.kit.zip;

import java.util.Map;

import com.google.common.collect.Maps;

import itez.kit.EStr;
import itez.kit.async.AsyncState;
import itez.kit.async.ICallBack;

public class ZipKit implements IZip {

	public static ZipKit me = new ZipKit();
	
	private Map<String, IZip> zipEngines = Maps.newHashMap();
	private String defaultEngine = "java";
	
	private ZipKit(){}
	
	public IZip by(String engineName){
		if(EStr.isEmpty(engineName)) engineName = defaultEngine;
		if(zipEngines.containsKey(engineName)) return zipEngines.get(engineName);
		IZip engine = null;
		if(engineName.equals("java")){
			engine = new ZipJava();
		}else{
			engine = new ZipJava();
		}
		zipEngines.put(engineName, engine);
		return engine;
	}

	@Override
	public String zip(String srcPath, String destPath) {
		return by(defaultEngine).zip(srcPath, destPath);
	}

	@Override
	public AsyncState zipAsync(String srcPath, String destPath) {
		return by(defaultEngine).zipAsync(srcPath, destPath);
	}

	@Override
	public AsyncState zipAsync(String srcPath, String destPath, ICallBack callback) {
		return by(defaultEngine).zipAsync(srcPath, destPath, callback);
	}

	@Override
	public String unzip(String srcPath, String destPath) {
		return by(defaultEngine).unzip(srcPath, destPath);
	}

	@Override
	public AsyncState unzipAsync(String srcPath, String destPath) {
		return by(defaultEngine).unzipAsync(srcPath, destPath);
	}

	@Override
	public AsyncState unzipAsync(String srcPath, String destPath, ICallBack callback) {
		return by(defaultEngine).unzipAsync(srcPath, destPath, callback);
	}

	public void setDefaultEngine(String defaultEngine) {
		this.defaultEngine = defaultEngine;
	}

	public void addEngine(String engineName, IZip engine) {
		zipEngines.put(engineName, engine);
	}
	
}
