package itez.kit.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

import itez.kit.ELog;
import itez.kit.ERet;
import itez.kit.EStr;
import itez.kit.async.AsyncKit;
import itez.kit.async.AsyncState;
import itez.kit.async.ICallBack;
import itez.kit.log.ELogBase;
import itez.kit.log.ExceptionUtil;

public class ZipJava implements IZip {

	public static final int BUFFER_SIZE = 2 * 1024;
	private ELogBase log = ELog.log(ZipJava.class);
	
	@Override
	public String zip(String srcPath, String destPath) {
		if(EStr.isEmpty(srcPath)) throw new RuntimeException("未传入源路径");
		int len = srcPath.length();
		char lastChr = srcPath.charAt(len - 1);
		if(lastChr == '/' || lastChr == '\\') srcPath = srcPath.substring(0, len - 1);
		File src = new File(srcPath);
		if (!src.exists()) throw new RuntimeException(srcPath + "不存在");
		if(EStr.isEmpty(destPath)) destPath = srcPath + ".zip";
		File zipFile = new File(destPath);
		ZipOutputStream zos = null;
		try {
			log.info("开始压缩：{}", srcPath);
			FileOutputStream fos = new FileOutputStream(zipFile);
			CheckedOutputStream cos = new CheckedOutputStream(fos, new CRC32());
			zos = new ZipOutputStream(cos);
			compress(src, zos, src.getName());
			log.info("压缩完成：{}", destPath);
			return destPath;
		} catch (Exception e) {
			log.error("压缩时发生错误。");
			log.error(ExceptionUtil.getMessage(e));
			throw new RuntimeException("压缩逻辑发生错误", e);
		} finally {
			if(zos != null){
				try {
					zos.close();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
	}

	@Override
	public AsyncState zipAsync(String srcPath, String destPath) {
		return zipAsync(srcPath, destPath, null);
	}

	@Override
	public AsyncState zipAsync(String srcPath, String destPath, ICallBack callback) {
		AsyncState state = AsyncKit.me.start(callback);
		new Thread(new Runnable() {
			@Override
			public void run() {
				String zipPath = zip(srcPath, destPath);
				state.complate(ERet.ok("zip", zipPath));
			}
		}).start();
		return state;
	}
	
	private static void compress(File sourceFile, ZipOutputStream zos, String dirName) throws Exception{
		byte[] buf = new byte[BUFFER_SIZE];
		if(sourceFile.isFile()){
			zos.putNextEntry(new ZipEntry(dirName));
			int len;
			FileInputStream in = new FileInputStream(sourceFile);
			while ((len = in.read(buf)) != -1){
				zos.write(buf, 0, len);
			}
			zos.closeEntry();
			in.close();
		}else{
			File[] listFiles = sourceFile.listFiles();
			if(listFiles == null || listFiles.length == 0){
				zos.putNextEntry(new ZipEntry(dirName + "/"));
				zos.closeEntry();
			}else{
				for (File file : listFiles) {
					compress(file, zos, dirName + "/" + file.getName());
				}
			}
		}
	}
	
	private static void uncompress(File sourceFile, String destPath) throws Exception{
		FileInputStream fis = new FileInputStream(sourceFile);
		ZipArchiveInputStream zstream = new ZipArchiveInputStream(fis);
		ZipArchiveEntry entry = null;
        byte[] buf = new byte[BUFFER_SIZE];
        while((entry = zstream.getNextZipEntry()) != null) {
        	String path = destPath.concat(File.separator).concat(entry.getName());
        	if(entry.isDirectory()){
            	File dest = new File(path);
            	if(!dest.exists()) dest.mkdirs();
        	}else{
        		int pit = path.lastIndexOf(".");
        		path = path.substring(0, pit).concat(path.substring(pit).toLowerCase());
            	FileOutputStream fos = new FileOutputStream(path);
            	int len = -1;
            	while((len = zstream.read(buf)) != -1) {
            		fos.write(buf, 0, len);
            	}
            	fos.close();
        	}
        }
        zstream.close();
        fis.close();
	}

	@Override
	public String unzip(String srcPath, String destPath) {
		if(EStr.isEmpty(srcPath)) throw new RuntimeException("未传入源路径");
		File src = new File(srcPath);
		if (!src.exists()) throw new RuntimeException(srcPath + "不存在");
		if(EStr.isEmpty(destPath)) destPath = src.getParent().concat(File.separator).concat(src.getName().split("\\.")[0]);
		try {
			log.info("开始解压缩：{}", srcPath);
			uncompress(src, destPath);
			log.info("解压缩完成：{}", destPath);
			return destPath;
		} catch (Exception e) {
			log.error("解压缩时发生错误。");
			log.error(ExceptionUtil.getMessage(e));
			throw new RuntimeException("解压缩逻辑发生错误", e);
		}
	}

	@Override
	public AsyncState unzipAsync(String srcPath, String destPath) {
		return unzipAsync(srcPath, destPath, null);
	}

	@Override
	public AsyncState unzipAsync(String srcPath, String destPath, ICallBack callback) {
		//暂未实现
		return null;
	}

}
