package itez.kit.sms;

import java.util.List;

import com.beust.jcommander.internal.Lists;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.sms.v20190711.SmsClient;
import com.tencentcloudapi.sms.v20190711.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20190711.models.SendSmsResponse;
import com.tencentcloudapi.sms.v20190711.models.SendStatus;

import itez.kit.ELog;
import itez.kit.EProp;

public class SmsLibTencent extends SmsLibBase implements ISms {

	private SmsClient client;
	private SendSmsRequest req;
	
	public SmsLibTencent() {
		Credential cred = new Credential(EProp.CloudTencentSecretId, EProp.CloudTencentSecretKey);
		ClientProfile clientProfile = new ClientProfile();
		client = new SmsClient(cred, "", clientProfile);
		req = new SendSmsRequest();
		req.setSmsSdkAppid(EProp.TencentSmsSdkAppid);
	}
	
	@Override
	public SmsItem send(String sign, String tempId, String phone, String[] paras) {
		List<SmsItem> items = send(sign, tempId, new String[]{ phone }, paras);
		if(items.size() > 0) return items.get(0);
		throw new RuntimeException("发送短信错误");
	}

	@Override
	public List<SmsItem> send(String sign, String tempId, String[] phones, String[] paras) {
		List<SmsItem> items = Lists.newArrayList();
		req.setSign(sign);
		req.setTemplateID(tempId);
		req.setPhoneNumberSet(formatPhoneCN(phones));
		req.setTemplateParamSet(paras);
		try {
			SendSmsResponse res = client.SendSms(req);
			SendStatus[] status = res.getSendStatusSet();
			for(int i=0; i<status.length; i++){
				SendStatus stu = status[i];
				String phone = stu.getPhoneNumber().replace("+86", "");
				SmsItem item = new SmsItem(phone, stu.getCode().equals("Ok"), stu.getMessage(), null);
				items.add(item);
				ELog.info("短信发送状态：".concat(phone).concat(": ").concat(stu.getMessage()));
			}
		} catch (TencentCloudSDKException e) {
			if(EProp.DevMode) e.printStackTrace();
			else ELog.error(e.getMessage());
		}
		return items;
	}

}
