package itez.kit.sms;

import java.util.Arrays;

import itez.kit.EStr;

public abstract class SmsLibBase {

	/**
	 * 格式化国内手机号码
	 * 
	 * @param phone 手机号
	 * @return
	 */
	String formatPhoneCN(String phone){
		if(EStr.isEmpty(phone)) throw new RuntimeException("空白手机号！");
		return "+86".concat(phone);
	}
	
	/**
	 * 格式化国内手机号码
	 * 
	 * @param phones 手机号数组
	 * @return
	 */
	String[] formatPhoneCN(String[] phones){
		if(EStr.isEmpty(phones)) throw new RuntimeException("空白手机号！");
		return Arrays.stream(phones).map(phone -> formatPhoneCN(phone)).toArray(String[]::new);
	}
	
}
