package itez.kit.sms;

import java.security.SecureRandom;
import java.util.Map;
import java.util.Random;

import com.google.common.collect.Maps;

import itez.kit.EProp;
import itez.kit.EStr;

public class SmsKit {

	private Map<String, ISms> smsLibs = Maps.newHashMap();
	public static final SmsKit me = new SmsKit();
	private SmsKit(){}
	
	private static final String SYMBOLS = "0123456789";
    private static final Random RANDOM = new SecureRandom();
    
    private Map<String, SmsItem> codeCache = Maps.newConcurrentMap();
	
	public ISms getLib(){
		return getLib(EProp.SmsPlan);
	}
	
	public ISms getLib(String libName){
		if(EStr.isEmpty(libName)) throw new RuntimeException("短信方案名称不能为空！");
		if(smsLibs.containsKey(libName)) return smsLibs.get(libName);
		ISms lib = null;
		if(libName.equals("Tencent")){
			lib = new SmsLibTencent();
		}
		if(lib == null) throw new RuntimeException("无效的短信方案！");
		smsLibs.put(libName, lib);
		return lib;
	}
	
	/**
	 * 生成随机验证码，默认6位数字
	 * @return
	 */
	public String generateValiCode(){
		return generateValiCode(6);
	}
	
	/**
	 * 生成随机验证码
	 * @param len 位数
	 * @return
	 */
	public String generateValiCode(int len){
		char[] chars = new char[len];
		for (int i = 0; i < chars.length; ++i) {
			chars[i] = SYMBOLS.charAt(RANDOM.nextInt(SYMBOLS.length()));
		}
		return new String(chars);
	}
	
	/**
	 * 添加验证码缓存
	 * @param phone
	 * @param code
	 */
	public void putCode(String phone, String code){
		putCode(new SmsItem(phone, true, null, code));
	}
	
	/**
	 * 添加验证码缓存
	 * @param item
	 */
	public void putCode(SmsItem item){
		codeCache.put(item.getPhone(), item);
	}
	
	/**
	 * 返回指定手机号码的验证信息
	 * @param phone 手机号
	 * @return
	 */
	public SmsItem getCode(String phone){
		return codeCache.get(phone);
	}

}
