package itez.kit.sms;

import java.util.Date;

public class SmsItem {

	private String phone;	//手机号
	private Boolean status;	//发送状态
	private String error;	//错误描述
	private Date cdate;		//发送时间
	private String code;	//验证码
	
	public SmsItem(String phone, Boolean status, String error, String code) {
		this.phone = phone;
		this.status = status;
		this.error = error;
		this.code = code;
		this.cdate = new Date();
	}
	
	/**
	 * 手机号
	 * @return
	 */
	public String getPhone() {
		return phone;
	}
	/**
	 * 发送状态
	 * @return
	 */
	public Boolean getStatus() {
		return status;
	}
	
	/**
	 * 错误描述
	 * @return
	 */
	public String getError() {
		return error;
	}

	/**
	 * 发送时间
	 * @return
	 */
	public Date getCdate() {
		return cdate;
	}
	/**
	 * 验证码
	 * @return
	 */
	public String getCode() {
		return code;
	}

	/**
	 * 设置验证码
	 * @param code
	 */
	public void setCode(String code) {
		this.code = code;
	}
	
}
