package itez.kit.sms;

import java.util.List;

public interface ISms {

	/**
	 * 发送单条短信
	 * 
	 * @param sign 短信签名内容，一般是【】中的内容
	 * @param tempId 短信模板 ID
	 * @param phone 接收方手机号
	 * @param paras 短信内容参数数组
	 */
	SmsItem send(String sign, String tempId, String phone, String[] paras);
	
	/**
	 * 发送批量短信
	 * 
	 * @param sign 短信签名内容，一般是【】中的内容
	 * @param tempId 短信模板 ID
	 * @param phones 接收方手机号数组
	 * @param paras 短信内容参数数组
	 */
	List<SmsItem> send(String sign, String tempId, String[] phones, String[] paras);
	
}
