/**
 * Result.java
 */
package itez.kit.restful;

import java.io.Serializable;

import itez.kit.EStr;

/**
 * <p>
 * RestFul返回值封装
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年4月22日 上午10:12:47
 */
public class Result implements Serializable {

	private static final long serialVersionUID = 4165163611445221484L;
	
	protected boolean state;	//状态：true（成功），false（失败）
	protected int code;			//状态码
	protected String desc;		//状态描述
	protected String msg;		//详细信息
	protected EMap data;		//返回数据
	
    private Result(EMap data){
    	this.state = true;
        this.code = ResultCode.SUCCESS.getCode();
        this.desc = ResultCode.SUCCESS.getDesc();
        this.msg = this.desc;
        this.data = null == data ? EMap.create() : data;
    }
    
    private Result(ResultCode resultCode, String desc){
    	this.state = false;
        if(EStr.isNull(resultCode)) resultCode = ResultCode.ERR_LOGIC;
        this.code = resultCode.getCode();
        this.desc = resultCode.getDesc();
        this.msg = desc;
        this.data = EMap.create();
    }
    
    /**
     * <p>
     * 成功时
     * </p>
     * 
     * @param data 返回数据
     * @return
     */
    public static Result success(){
        return new Result(null);
    }
    
    /**
     * <p>
     * 成功时
     * </p>
     * 
     * @param data 返回数据
     * @return
     */
    public static Result success(Object key, Object value){
        return new Result(EMap.by(key, value));
    }
    
    /**
     * <p>
     * 失败时
     * </p>
     * 
     * @param resultCode 状态码
     * @return
     */
    public static Result fail(){
        return new Result(null, null);
    }
    
    /**
     * <p>
     * 失败时
     * </p>
     * 
     * @param resultCode 状态码
     * @return
     */
    public static Result fail(ResultCode resultCode){
        return new Result(resultCode, null);
    }
    
    /**
     * <p>
     * 失败时
     * </p>
     * 
     * @param resultCode 状态码
     * @param msg 详细描述
     * @return
     */
    public static Result fail(String msg){
        return new Result(ResultCode.ERR_LOGIC, msg);
    }
    
    /**
     * <p>
     * 失败时
     * </p>
     * 
     * @param resultCode 状态码
     * @param msg 详细描述
     * @return
     */
    public static Result fail(ResultCode resultCode, String msg){
        return new Result(resultCode, msg);
    }
    
    /**
     * <p>
     * 添加数据
     * </p>
     * 
     * @param key
     * @param value
     * @return
     */
    public Result set(Object key, Object value){
    	this.data.set(key, value);
    	return this;
    }

	public boolean getState() {
		return state;
	}

	public int getCode() {
		return code;
	}

	public String getDesc() {
		return desc;
	}

	public String getMsg() {
		return msg;
	}

	public EMap getData() {
		return data;
	}
	
}
