/**
 * 
 */
package itez.kit.restful;

import java.util.HashMap;
import java.util.Map;

import itez.kit.EStr;

/**
 * <p>
 * 键值对
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年4月20日 下午4:35:03
 */
@SuppressWarnings({"rawtypes", "unchecked"})
public class EMap extends HashMap {

	private static final long serialVersionUID = -536264630368648754L;

    //*******************************************  创建实例   ***********************************************/

	/**
	 * 构造函数
	 */
	public EMap() {
	}
	
	/**
	 * <p>
	 * 创建新实例
	 * </p>
	 * 
	 * @return JMap
	 */
	public static EMap create(){
		return new EMap();
	}
	
	/**
	 * <p>
	 * 创建新实例，同时初始化一对数据
	 * </p>
	 * 
	 * @param key 键名
	 * @param value 值
	 * @return JMap
	 */
	public static EMap by(Object key, Object value){
		return new EMap().set(key, value);
	}

    //*******************************************  添加数据   ***********************************************/

	/**
	 * <p>
	 * 添加数据
	 * </p>
	 * 
	 * @param key 键名
	 * @param value 值
	 * @return JMap
	 */
	public EMap set(Object key, Object value) {
		super.put(key, value);
		return this;
	}
	
	/**
	 * <p>
	 * 添加数据
	 * </p>
	 * 
	 * @param map Map
	 * @return JMap
	 */
	public EMap set(Map map) {
		super.putAll(map);
		return this;
	}
	
	/**
	 * <p>
	 * 添加数据
	 * </p>
	 * 
	 * @param kv JMap
	 * @return JMap
	 */
	public EMap set(EMap kv) {
		super.putAll(kv);
		return this;
	}

	/**
	 * <p>
	 * 添加非Null数据
	 * </p>
	 * 
	 * @param key 键名
	 * @param value 值
	 * @return JMap
	 */
	public EMap setIfNotNull(Object key, Object value) {
		if (EStr.notNull(value)) {
			set(key, value);
		}
		return this;
	}

	/**
	 * <p>
	 * 添加非空数据
	 * </p>
	 * 
	 * @param key 键名
	 * @param value 值
	 * @return JMap
	 */
	public EMap setIfNotEmpty(Object key, String value) {
		if (EStr.notEmpty(value)) {
			set(key, value);
		}
		return this;
	}

    //*******************************************  返回数据   ***********************************************/

	/**
	 * <p>
	 * 返回指定泛型键值
	 * </p>
	 * 
	 * @param key 键名
	 * @return Object
	 */
	public <T> T getAs(Object key) {
		return (T)get(key);
	}
	
	/**
	 * <p>
	 * 返回字符串
	 * </p>
	 * 
	 * @param key 键名
	 * @return String
	 */
	public String getStr(Object key) {
		Object s = get(key);
		return s != null ? s.toString() : null;
	}
	
	/**
	 * <p>
	 * 返回整型
	 * </p>
	 * 
	 * @param key 键名
	 * @return Integer
	 */
	public Integer getInt(Object key) {
		Number n = (Number)get(key);
		return n != null ? n.intValue() : null;
	}
	
	/**
	 * <p>
	 * 返回长整型
	 * </p>
	 * 
	 * @param key 键名
	 * @return Long
	 */
	public Long getLong(Object key) {
		Number n = (Number)get(key);
		return n != null ? n.longValue() : null;
	}
	
	/**
	 * <p>
	 * 返回数值型
	 * </p>
	 * 
	 * @param key 键名
	 * @return Number
	 */
	public Number getNumber(Object key) {
		return (Number)get(key);
	}
	
	/**
	 * <p>
	 * 返回布尔型
	 * </p>
	 * 
	 * @param key 键名
	 * @return Boolean
	 */
	public Boolean getBoolean(Object key) {
		return (Boolean)get(key);
	}

    //*******************************************  删除数据   ***********************************************/

	/**
	 * <p>
	 * 删除键值
	 * </p>
	 * 
	 * @param key 键名
	 * @return JMap
	 */
	public EMap delete(Object key) {
		super.remove(key);
		return this;
	}
	
}
