package itez.kit.queue;

import java.util.Map;
import com.google.common.collect.Maps;
import itez.kit.EStr;

public class QueueKit {

	public static QueueKit me = new QueueKit();
	
	private Map<String, QueueFactory> factorys = Maps.newHashMap();
	private static final String DEF_FACTORY_NAME = "main";
	private static final int MAX_QUEUE_SIZE = 5000;
	private static final int THREAD_POOL_SIZE = 20;
	
	private QueueKit(){}

	public QueueFactory get(String factoryName){
		if(EStr.isEmpty(factoryName)) factoryName = DEF_FACTORY_NAME;
		if(factorys.containsKey(factoryName)) return factorys.get(factoryName);
		return null;
	}
	
	public QueueFactory create(IQueueHandle customerHandle){
		return create(DEF_FACTORY_NAME, customerHandle, MAX_QUEUE_SIZE, THREAD_POOL_SIZE, false);
	}
	
	public QueueFactory create(IQueueHandle customerHandle, boolean longTerm){
		return create(DEF_FACTORY_NAME, customerHandle, MAX_QUEUE_SIZE, THREAD_POOL_SIZE, longTerm);
	}
	
	public QueueFactory create(String factoryName, IQueueHandle customerHandle){
		return create(factoryName, customerHandle, MAX_QUEUE_SIZE, THREAD_POOL_SIZE, false);
	}
	
	public QueueFactory create(String factoryName, IQueueHandle customerHandle, boolean longTerm){
		return create(factoryName, customerHandle, MAX_QUEUE_SIZE, THREAD_POOL_SIZE, longTerm);
	}
	
	public QueueFactory create(String factoryName, IQueueHandle customerHandle, int maxQueueSize){
		return create(factoryName, customerHandle, maxQueueSize, THREAD_POOL_SIZE, false);
	}
	
	public QueueFactory create(String factoryName, IQueueHandle customerHandle, int maxQueueSize, int threadPoolSize){
		return create(factoryName, customerHandle, maxQueueSize, threadPoolSize, false);
	}
	
	public QueueFactory create(String factoryName, IQueueHandle customerHandle, int maxQueueSize, int threadPoolSize, boolean longTerm){
		if(factorys.containsKey(factoryName)) throw new RuntimeException("名称为[" + factoryName + "]的工厂已存在！");
		QueueFactory factory = new QueueFactory(customerHandle, maxQueueSize, threadPoolSize, longTerm);
		factorys.put(factoryName, factory);
		return factory;
	}
	
}
