package itez.kit.poi;

import java.util.List;

import com.beust.jcommander.internal.Lists;

public class ESheet {

	private Integer index = 0;
	private String caption = null;
	private Integer cellCount = 0;
	private Integer rowCount = 0;
	private ERow firstRow = null;
	private List<ERow> rows = Lists.newArrayList();
	
	public ERow getRow(Integer rowIndex){
		return rows.get(rowIndex);
	}
	public ESheet putRow(ERow row){
		this.rows.add(row);
		return this;
	}
	public Integer getIndex() {
		return index;
	}
	public ESheet setIndex(Integer index) {
		this.index = index;
		return this;
	}
	public String getCaption() {
		return caption;
	}
	public ESheet setCaption(String caption) {
		this.caption = caption;
		return this;
	}
	public Integer getCellCount() {
		return cellCount;
	}
	public ESheet setCellCount(Integer colCount) {
		this.cellCount = colCount;
		return this;
	}
	public Integer getRowCount() {
		return rowCount;
	}
	public ESheet setRowCount(Integer rowCount) {
		this.rowCount = rowCount;
		return this;
	}
	public ERow getFirstRow() {
		return firstRow != null ? firstRow : rows.size() > 0 ? rows.get(0) : null;
	}
	public ESheet setFirstRow(ERow firstRow) {
		this.firstRow = firstRow;
		return this;
	}
	public List<ERow> getRows() {
		return rows;
	}
	public ESheet setRows(List<ERow> rows) {
		this.rows = rows;
		return this;
	}

}
