package itez.kit.poi;

import java.util.Map;

import com.google.common.collect.Maps;

public class ECell {

	private Integer rowIndex = 0;
	private Integer cellIndex = 0;
	private String type = "";
	private String expr = null;
	private Map<String, Object> value = Maps.newHashMap();
	
	public Integer getRowIndex() {
		return rowIndex;
	}
	public ECell setRowIndex(Integer rowIndex) {
		this.rowIndex = rowIndex;
		return this;
	}
	public Integer getCellIndex() {
		return cellIndex;
	}
	public ECell setCellIndex(Integer colIndex) {
		this.cellIndex = colIndex;
		return this;
	}
	public String getType() {
		return type;
	}
	public ECell setType(String type) {
		this.type = type;
		return this;
	}
	public String getExpr() {
		return expr;
	}
	public ECell setExpr(String expr) {
		this.expr = expr;
		return this;
	}
	public Object getValue() {
		return this.value.get(this.type);
	}
	public ECell setValue(Map<String, Object> value) {
		this.value = value;
		return this;
	}
	
}
