package itez.kit.pic;

import java.util.Map;

import com.google.common.collect.Maps;

public class EPicKit {

	public static enum PicEngine { java, thumbnailator }
	private static final PicEngine DEF_ENGINE = PicEngine.thumbnailator;
	private static Map<PicEngine, EPic> engineMap = Maps.newHashMap();
	
	public static EPic use(){
		return use(DEF_ENGINE);
	}
	
	public static EPic use(PicEngine eng){
		EPic epic = engineMap.get(eng);
		if(epic != null) return epic;
		
		if(eng == PicEngine.thumbnailator) epic = new EPicThumbnailator();
		else epic = null;
		
		engineMap.put(eng, epic);
		return epic;
	}
	
}
