package itez.kit.pic;

import java.awt.image.BufferedImage;

public abstract class EPic {

	/**
	 * 更改图片质量
	 * 
	 * @param srcPath 源图片路径
	 * @param destPath 输出图片路径
	 * @param quality 输出图片质量（0-1）
	 */
	public abstract void compress(String srcPath, String destPath, Float quality);
	public abstract BufferedImage compress(String srcPath, Float quality);
	
	/**
	 * 等比例缩放图片
	 * 
	 * @param srcPath 源图片路径
	 * @param destPath 输出图片路径
	 * @param quality 输出图片质量（0-1）
	 * @param scale 缩放率
	 */
	public abstract void compress(String srcPath, String destPath, Float quality, Float scale);
	public abstract BufferedImage compress(String srcPath, Float quality, Float scale);

	/**
	 * 等比例调整图片大小
	 * 
	 * @param srcPath 源图片路径
	 * @param destPath 输出图片路径
	 * @param quality 输出图片质量（0-1）
	 * @param width 宽度
	 * @param height 高度
	 * 
	 * 说明：如果原图的宽度和高度都小于指定值，则输出图不做调整；如果宽度小于指定值高度大于指定值，则高度缩小到指定值，宽度按比例变小
	 */
	public abstract void compress(String srcPath, String destPath, Float quality, Integer width, Integer height);
	public abstract BufferedImage compress(String srcPath, Float quality, Integer width, Integer height);

	/**
	 * 自由调整图片大小，不考虑图片是否失真
	 * 
	 * @param srcPath 源图片路径
	 * @param destPath 输出图片路径
	 * @param quality 输出图片质量（0-1）
	 * @param width 宽度
	 * @param height 高度
	 */
	public abstract void compressFree(String srcPath, String destPath, Float quality, Integer width, Integer height);
	public abstract BufferedImage compressFree(String srcPath, Float quality, Integer width, Integer height);
	
}
