package itez.kit.pay.ccb.netpay;

import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;

public class RSAPrivKey implements RSAPrivateKey {
	private static final long serialVersionUID = 7028034168592383270L;
	public static final String ident = "$Id: RSAPrivKey.java,v 1.6 1999/01/24 23:03:51 leachbj Exp $";
	protected BigInteger modulus;
	protected BigInteger d;

	public RSAPrivKey() {
	}

	public RSAPrivKey(BigInteger biginteger, BigInteger biginteger1) {
		this.modulus = biginteger;
		this.d = biginteger1;
	}

	public String getAlgorithm() {
		return "RSA";
	}

	public byte[] getEncoded() {
		return toString().getBytes();
	}

	public String getFormat() {
		return "ASCII";
	}

	public BigInteger getModulus() {
		return this.modulus;
	}

	public BigInteger getPrivateExponent() {
		return this.d;
	}

	public String toString() {
		return this.modulus.toString(16) + "." + this.d.toString(16);
	}
}
