package itez.kit.pay.ccb.netpay;

import java.security.Provider;

public final class ABAProvider extends Provider {
	private static final long serialVersionUID = 8464041301700091954L;
	public static final String ident = "$Id: ABAProvider.java,v 1.25 1999/02/11 04:32:50 leachbj Exp $";
	private static String info = "ABA Security Provider v1.1, SHA, MD5 message Digests, and Crypto algorithms.";

	public ABAProvider() {
		super("ABA", 1.1D, info);
		put("MessageDigest.MD5", "itez.kit.pay.ccb.netpay.MD5");
		put("MessageDigest.SHA-1", "itez.kit.pay.ccb.netpay.SHA1");
		put("Alg.Alias.MessageDigest.SHA1", "SHA-1");
		put("Alg.Alias.MessageDigest.SHA", "SHA-1");
		put("MessageDigest.SHA-0", "itez.kit.pay.ccb.netpay.SHA0");
		put("MessageDigest.CRC16", "itez.kit.pay.ccb.netpay.CRC16");
		put("Cipher.RSA", "itez.kit.pay.ccb.netpay.RSA");
		put("Alg.Alias.Cipher.OID.1.2.840.113549.1.1.1", "RSA");
		put("Cipher.RC4", "itez.kit.pay.ccb.netpay.RC4");
		put("Cipher.DES", "itez.kit.pay.ccb.netpay.DES");
		put("Cipher.DESede", "itez.kit.pay.ccb.netpay.DESede");
		put("Cipher.IDEA", "itez.kit.pay.ccb.netpay.IDEA");
		put("Cipher.Blowfish", "itez.kit.pay.ccb.netpay.Blowfish");
		put("Cipher.Twofish", "itez.kit.pay.ccb.netpay.Twofish");
		put("Cipher.PBEWithMD5AndDES", "itez.kit.pay.ccb.netpay.PBEWithMD5AndDES");
		put("Cipher.PBEWithSHA1And128BitRC4", "itez.kit.pay.ccb.netpay.PBEWithSHA1And128BitRC4");
		put("Mac.DESMac", "itez.kit.pay.ccb.netpay.DESMac");
		put("Alg.Alias.Mac.DES-MAC", "DESMac");
		put("KeyPairGenerator.RSA", "itez.kit.pay.ccb.netpay.RSAKeyPairGenerator");
		put("Alg.Alias.KeyPairGenerator.OID.1.2.840.113549.1.1.1", "RSA");
		put("Alg.Alias.KeyPairGenerator.1.2.840.113549.1.1.1", "RSA");
		put("KeyGenerator.RC4", "itez.kit.pay.ccb.netpay.RC4KeyGenerator");
		put("KeyGenerator.DES", "itez.kit.pay.ccb.netpay.DESKeyGenerator");
		put("KeyGenerator.DESede", "itez.kit.pay.ccb.netpay.DESedeKeyGenerator");
		put("KeyGenerator.IDEA", "itez.kit.pay.ccb.netpay.IDEAKeyGenerator");
		put("KeyGenerator.Blowfish", "itez.kit.pay.ccb.netpay.BlowfishKeyGenerator");
		put("KeyGenerator.Twofish", "itez.kit.pay.ccb.netpay.TwofishKeyGenerator");
		put("KeyFactory.RSA", "itez.kit.pay.ccb.netpay.RSAKeyFactory");
		put("Alg.Alias.KeyFactory.1.2.840.113549.1.1.1", "RSA");
		put("SecretKeyFactory.DES", "itez.kit.pay.ccb.netpay.DESKeyFactory");
		put("SecretKeyFactory.DESede", "itez.kit.pay.ccb.netpay.DESedeKeyFactory");
		put("SecretKeyFactory.RC4", "itez.kit.pay.ccb.netpay.RC4KeyFactory");
		put("SecretKeyFactory.IDEA", "itez.kit.pay.ccb.netpay.IDEAKeyFactory");
		put("SecretKeyFactory.Blowfish", "itez.kit.pay.ccb.netpay.BlowfishKeyFactory");
		put("SecretKeyFactory.Twofish", "itez.kit.pay.ccb.netpay.TwofishKeyFactory");
		put("SecretKeyFactory.PBEWithMD5AndDES", "itez.kit.pay.ccb.netpay.PBEKeyFactory");
		put("SecretKeyFactory.PBEWithSHA1And128BitRC4", "itez.kit.pay.ccb.netpay.PBEKeyFactory");
		put("KeyStore.ABA", "itez.kit.pay.ccb.netpay.KeyStore");
		put("Signature.MD5withRSA", "itez.kit.pay.ccb.netpay.MD5withRSA");
		put("Alg.Alias.Signature.MD5/RSA", "MD5withRSA");
		put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.4", "MD5withRSA");
		put("Alg.Alias.Signature.1.2.840.113549.1.1.4", "MD5withRSA");
		put("Alg.Alias.Signature.1.3.14.3.2.25", "MD5withRSA");
		put("CertificateFactory.X509", "au.net.aba.cert.ABAX509CertFactory");
		put("Alg.Alias.CertificateFactory.X.509", "X509");
	}
}
