package itez.kit.pay;

import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.beust.jcommander.internal.Maps;

import itez.kit.EPara;
import itez.kit.ERet;
import itez.kit.pay.ccb.PayCCB;

/**
 * 支付工具类
 * @author netwild
 *
 */
public class PayKit {

	/**
	 * 支持的支付渠道
	 * 
	 *   1、CCB：建行聚合支付
	 * 
	 * @author netwild
	 */
	public static enum Channel {
		CCB("建行聚合支付");
		private String caption = "";
		private Channel(String caption){
			this.caption = caption;
		}
		public String getCaption(){
			return this.caption;
		}
	}
	
	/**
	 * 支付渠道实现类缓存
	 */
	private Map<Channel, PayBase> pays = Maps.newHashMap();
	
	/**
	 * 单列模式
	 */
	public static final PayKit me = new PayKit();
	private PayKit(){}
	
	/**
	 * 初始化支付渠道
	 * @param channel
	 * @return
	 */
	private PayBase init(Channel channel){
		PayBase pay = pays.get(channel);
		if(pay == null){
			if(channel == Channel.CCB) pay = new PayCCB();
			else throw new RuntimeException("无法识别的支付渠道：" + channel.name());
		}
		return pay;
	}
	
	/**
	 * 根据参数动态获取二维码
	 * 
	 * @param params 保存的渠道配置信息，各渠道不相同
	 * @param orderId 订单号
	 * @param payment 支付金额
	 * @param remark1 备注1
	 * @param remark2 备注2
	 * @return
	 */
	public String getQrCode(JSONObject configs, String orderId, String payment, String remark1, String remark2){
		String channelCode = configs.getString("code");
		Channel channel = Channel.valueOf(channelCode);
		PayBase pay = init(channel);
		return pay.getQrCode(configs, orderId, payment, remark1, remark2);
	}

	/**
	 * 支付完成的回调处理
	 * 
	 * @param configs 保存的渠道配置信息，各渠道不相同
	 * @param paras request请求参数封装
	 * @return
	 */
	public ERet callback(JSONObject configs, EPara paras){
		String channelCode = configs.getString("code");
		Channel channel = Channel.valueOf(channelCode);
		PayBase pay = init(channel);
		return pay.callback(configs, paras);
	}
	
	/**
	 * 返回支付渠道的参数配置项
	 * @param channel
	 * @return
	 */
	public String paramConfig(Channel channel){
		PayBase pay = init(channel);
		return pay.paramsConfig();
	}
	
}
