package itez.kit.pay;

import com.alibaba.fastjson.JSONObject;

import itez.kit.EPara;
import itez.kit.ERet;

/**
 * 支付渠道抽象类
 * 
 * @author netwild
 */
public abstract class PayBase {
	
	public final static String PAYMENT_ORDER_ID = "PAYMENT_ORDER_ID";
	public final static String PAYMENT_MONEY = "PAYMENT_MONETY";
	public final static String PAYMENT_REMARK1 = "PAYMENT_REMARK1";
	public final static String PAYMENT_REMARK2 = "PAYMENT_REMARK2";

	/**
	 * 根据参数动态获取二维码
	 * 
	 * @param configs 保存的渠道配置信息，各渠道不相同
	 * @param orderId 订单号
	 * @param payment 支付金额
	 * @param remark1 备注1
	 * @param remark2 备注2
	 * @return
	 */
	public abstract String getQrCode(JSONObject configs, String orderId, String payment, String remark1, String remark2);

	/**
	 * 支付完成的回调处理
	 * 
	 * @param configs 保存的渠道配置信息，各渠道不相同
	 * @param paras request请求参数封装
	 * @return
	 */
	public abstract ERet callback(JSONObject configs, EPara paras);
	
	/**
	 * 返回渠道的参数配置项（[{field: '', title: ''}...]）
	 * @return
	 */
	public abstract String paramsConfig();
	
}
