package itez.kit.mqtt;

import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttTest {

	public static void main(String[] args) throws InterruptedException {
		String host = "ws://www.itez.com.cn:61623";
		String user = "client";
		String pass = "apolloclient";
		String clientId = "JAVA-TEST";
		String topic = "test11";
		MqttUtil mqtt = new MqttUtil(host, user, pass, clientId);
		mqtt.connect(new MqttCallback() {
			@Override
			public void messageArrived(String topic, MqttMessage message) throws Exception {
				System.out.println("接收消息：" + topic);
				System.out.println("接收消息：" + message.toString());
			}
			@Override
			public void deliveryComplete(IMqttDeliveryToken token) {
				System.out.println("发送完成");
			}
			@Override
			public void connectionLost(Throwable cause) {
				System.out.println("连接丢失");
				mqtt.connect(null);
			}
		});
		mqtt.subscribe(topic);
		mqtt.publish(topic, "来自JAVA");
	}
	
}
