package itez.kit.mall;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

/**
 * 邮件发送类之：邮件发送
 * @author z.mingyu@mytm3.com
 */

public class MailSender {
	/**   
	 * 以文本格式发送邮件   
	 * @param mailInfo 待发送的邮件的信息   
	 */
	public static boolean sendTextMail(MailInfo mailInfo) {
		MailIden authenticator = null;
		Properties pro = mailInfo.getProperties();
		if (mailInfo.isValidate()) {
			authenticator = new MailIden(mailInfo.getUserName(), mailInfo.getPassword());
		} 
		Session sendMailSession = Session.getDefaultInstance(pro, authenticator);
		try {
			Message mailMessage = new MimeMessage(sendMailSession);
			String nickName = mailInfo.getNickName();
			String emailFrom = mailInfo.getFromAddress();
			if(nickName != null){
				nickName = javax.mail.internet.MimeUtility.encodeText(nickName);
				emailFrom = nickName + " <" + emailFrom + ">";
			}
			Address from = new InternetAddress(emailFrom);
			mailMessage.setFrom(from);
			Address to = new InternetAddress(mailInfo.getToAddress());
			mailMessage.setRecipient(Message.RecipientType.TO, to);
			mailMessage.setSubject(mailInfo.getSubject());
			mailMessage.setSentDate(new Date());
			String mailContent = mailInfo.getContent();
			mailMessage.setText(mailContent);
			Transport.send(mailMessage);
			return true;
		} catch (Exception ex) {
			ex.printStackTrace();
			return false;
		}
	}

	/**   
	 * 以HTML格式发送邮件   
	 * @param mailInfo 待发送的邮件信息   
	 */
	public static boolean sendHtmlMail(MailInfo mailInfo) {
		MailIden authenticator = null;
		Properties pro = mailInfo.getProperties();
		if (mailInfo.isValidate()) {
			authenticator = new MailIden(mailInfo.getUserName(), mailInfo.getPassword());
		}
		Session sendMailSession = Session.getDefaultInstance(pro, authenticator);
		try {
			Message mailMessage = new MimeMessage(sendMailSession);
			String nick = mailInfo.getNickName();
			String emailFrom = mailInfo.getFromAddress();
			if(nick != null){
				nick = javax.mail.internet.MimeUtility.encodeText(nick);
				emailFrom = nick + " <" + emailFrom + ">";
			}
			Address from = new InternetAddress(emailFrom);
			mailMessage.setFrom(from);
			Address to = new InternetAddress(mailInfo.getToAddress());
			mailMessage.setRecipient(Message.RecipientType.TO, to);
			mailMessage.setSubject(mailInfo.getSubject());
			mailMessage.setSentDate(new Date());
			Multipart mainPart = new MimeMultipart();
			BodyPart html = new MimeBodyPart();
			html.setContent(mailInfo.getContent(), "text/html; charset=utf-8");
			mainPart.addBodyPart(html);
			mailMessage.setContent(mainPart);
			Transport.send(mailMessage);
			return true;
		} catch (Exception ex) {
			ex.printStackTrace();
			return false;
		}
	}

}
