package itez.kit.eval;

import java.util.Map;

import com.google.common.collect.Maps;

import itez.kit.ELog;
import itez.kit.log.ELogBase;

@SuppressWarnings("unused")
public class EvalFactory {

	public final static EvalFactory me = new EvalFactory();
	private static final ELogBase log = ELog.log(EvalFactory.class);
	private IEngine eng = null;
	private EvalFactory(){}
	private final String DEF_ENGINE = "nashorn";
	private final Map<String, IEngine> engines = Maps.newConcurrentMap();
	
	public IEngine getEngine(){
		return getEngine(DEF_ENGINE);
	}
	
	public IEngine getEngine(String engineName){
		if(engines.containsKey(engineName)){
			return engines.get(engineName);
		}else{
			if(engineName.equals(DEF_ENGINE)){
				IEngine eng = new NashornImpl();
				engines.put(DEF_ENGINE, eng);
				return eng;
			}
		}
		throw new RuntimeException("未找到匹配的引擎：" + engineName);
	}
	
}
