package itez.kit.async;

import java.util.Map;
import com.google.common.collect.Maps;
import itez.kit.ERet;

public class AsyncKit {

	public static AsyncKit me = new AsyncKit();
	
	private Map<String, AsyncState> states = Maps.newConcurrentMap();
	
	public AsyncState start(){
		return start(null);
	}
	
	public AsyncState start(ICallBack callback){
		AsyncState state = new AsyncState(callback);
		states.put(state.getId(), state);
		return state;
	}
	
	public AsyncState end(String stateId, ERet ret){
		AsyncState state = states.get(stateId);
		if(state == null) throw new RuntimeException("未找到对于的AsyncState：" + stateId);
		return end(state, ret);
	}
	
	public AsyncState end(AsyncState state, ERet ret){
		state.complate(ret);
		return state;
	}
	
}
