package itez.kit;

import java.util.Map;

import com.jfinal.kit.HashKit;
import com.jfinal.kit.Kv;
import com.jfinal.template.Directive;
import com.jfinal.template.Engine;
import com.jfinal.template.Env;
import com.jfinal.template.Template;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.Scope;

/**
 * 表达式解析
 * @author netwild
 *
 */
@SuppressWarnings("rawtypes")
public class El {

	private static Engine engineExpr = new Engine();
	private static final String RETURN_VALUE_KEY = "_RETURN_VALUE_";

	static {
		engineExpr.addDirective("eval", InnerEvalDirective.class);
		addSharedObject(engineExpr);
	}
	
	public static void addSharedObject(Engine engine){
		engine.addSharedObject("EUid", new EUid());
		engine.addSharedObject("EStr", new EStr());
		engine.addSharedObject("ENum", new ENum());
		engine.addSharedObject("ECode", new ECode());
		engine.addSharedObject("EHash", new HashKit());
		engine.addSharedObject("EDate", new itez.kit.EDate());
		engine.addSharedObject("ERegex", new itez.kit.ERegex());
		engine.addSharedObject("EJson", new itez.kit.EJson());
		engine.addSharedObject("Module", new itez.plat.quick.logic.ModuleUtil());
	}
	
	public static Engine getEngine() {
		return engineExpr;
	}
	
	/**
	 * 执行表达式
	 * @param expression 表达式
	 * @return
	 */
	public static <T> T exec(String expression){
		return exec(expression, Kv.create());
	}
	
	/**
	 * 执行表达式
	 * @param expression 表达式
	 * @param context 上下文参数表
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static <T> T exec(String expression, Map context){
		if(expression.startsWith("#(")){
			int len = expression.length();
			expression = expression.substring(2, len - 1);
		}
		String stringTemplate = "#eval(" + expression + ")";
		Template template = engineExpr.getTemplateByString(stringTemplate);
		template.render(context, (java.io.Writer)null);
		return (T)context.get(RETURN_VALUE_KEY);
	}
	
	public static String render(String stringTemplate, Map context){
		Template template = engineExpr.getTemplateByString(stringTemplate);
		return template.renderToString(context);
	}
	
	public static class InnerEvalDirective extends Directive {
		public void exec(Env env, Scope scope, Writer writer) {
			Object value = exprList.eval(scope);
			scope.set(RETURN_VALUE_KEY, value);
		}
	}
	
	@SuppressWarnings("unchecked")
	public static void main(String[] args) {
		int a = 11;
		String expression = "#(EStr.addPrefix(1+2+a, 5))";
		
		ERet map = ERet.create();
		map.put("a", a);
		map.put("EStr", new EStr());
		String ret = El.exec(expression, map);
		System.out.println(ret);
	}
	
}
