package itez.kit;

import com.jfinal.kit.PathKit;
import com.jfinal.kit.Prop;
import com.jfinal.kit.PropKit;

import itez.core.launch.JW;

public class EProp {

	// 加载项目默认配置文件
	private final static Prop PROP = PropKit.use(JW.MainConfigName);
	
	/******************** 基本配置 ********************/

	// 系统名称
	public final static String SysCaption = PROP.get("SysCaption", "数据梦工厂");
	// 系统代码
	public final static String SysCode = PROP.get("SysCode", "DDF");
	// 全局统一字符集
	public final static String Charset = PROP.get("Charset", "UTF-8");
	// 是否为调试模式，非调试模式时不显示详细输出信息，且视图文件修改后不立即生效
	public final static Boolean DevMode = PROP.getBoolean("DevMode", false);
	// Session保持时间，超过该时间之后，登录状态失效，默认30分钟
	public final static Integer SessionTimeOutMinutes = PROP.getInt("SessionTimeOutMinutes", 30);
	// 默认主模块别名（该模块中必须含有一个继承自EControllerDef的控制器）
	public final static String DefaultModuleCode = PROP.get("DefaultModuleCode", "plat");
	// 网站模板文件主目录，为空时将使用当前项目的“webapp/siteTemp”作为默认主目录
	public final static String SiteTempRoot = EStr.ifEmpty(PROP.get("SiteTempRoot"), PathKit.getWebRootPath() + "/siteTemp");
	// 是否允许跨域（如果线上环境使用Nginx，并已做跨域设置，此处应设置为false）
	public final static Boolean CrossOrigin = PROP.getBoolean("CrossOrigin", false);
	
	public final static String License = PROP.get("License");
	
	/********************* 泛域名解析配置 ********************/
	
	// 是否开启泛域名解析（true：开启，false：关闭）
	public final static Boolean DomainHandle = PROP.getBoolean("DomainHandle", false);
	// 域名解析方式（前缀：prefix；后缀：postfix，其中前缀模式需服务器支持泛域名解析）
	public final static String DomainMode = PROP.get("DomainMode", "postfix");
	// 默认域名（当泛域名解析关闭，或未匹配到域名时，将使用默认域名）
	public final static String DomainDefault = PROP.get("DomainDefault", "www");
	// 域名模板（子域占位符 ${domain} ）
	public final static String DomainTemplate = PROP.get("DomainTemplate", "http://${domain}.itez.com.cn");
	
	/********************* 资源路径配置 ********************/

	// 是否使用CDN
	public final static Boolean CommonUseCDN = PROP.getBoolean("CommonUseCDN", false);
	// 公共静态资源访问地址（本地或HTTP）
	public final static String CommonResLibPath = PROP.get("CommonResLibPath", "/common/res");
	// 公共图片库访问地址（本地或HTTP）
	public final static String CommonPicLibPath = PROP.get("CommonPicLibPath", "/common/pic");
	
	// 公共布局文件路径（相对于“src/main/resources/META-INF/resources”的本地路径，不可以使用HTTP网络地址）
	public final static String TempLayoutPath = PROP.get("TempLayoutPath", "/common/layout");
	// 公共视图文件路径（相对于“src/main/resources/META-INF/resources”的本地路径，不可以使用HTTP网络地址）
	public final static String TempCommonPath = PROP.get("TempCommonPath", "/common/temp");
	// 首页视图文件路径（相对于“src/main/resources/META-INF/resources”的本地路径，不可以使用HTTP网络地址）
	public final static String TempIndexPath = PROP.get("TempIndexPath", "/main/temp/index.html");
	// 错误页面视图文件路径（相对于“src/main/resources/META-INF/resources”的本地路径，不可以使用HTTP网络地址）
	public final static String TempErrorPath = PROP.get("TempErrorPath", "/common/temp/error.html");
	// 登录页面视图文件路径（相对于“src/main/resources/META-INF/resources”的本地路径，不可以使用HTTP网络地址）
	public final static String TempLoginPath = PROP.get("TempLoginPath", "/common/temp/login.html");
	
	/********************* 文件上传缓存配置 ********************/

	// 文件缓存目录，仅存储临时上传文件。注：以"/"或"\"或盘符打头时，为绝对路径；否则为WebRoot下的相对路径
	public final static String FileUploadTemp = PROP.get("FileUploadTemp", "FileUploadTemp");

	// 文件上传大小限制
	public final static Integer MaxPostSize = PROP.getInt("MaxPostSize", 10485760);

	/********************* 文件存储方案配置 ********************/
	
	// 文件存储方案名称：Local（本地存储）、QiNiu（七牛云）、Tencent（腾讯COS）
	public final static String FileStorePlan = PROP.get("FileStorePlan", "Local");
	
	// Local（本地存储）的文件保存硬盘路径，以"/"或"\"或盘符打头时，为绝对路径；否则为WebRoot下的相对路径
	public final static String LocalFilePath = PROP.get("LocalFilePath", "FileUploads");
	// Local（本地存储）的文件访问域名
	public final static String LocalFileUrl = PROP.get("LocalFileUrl", "/FileUploads");
	
	// 七牛云存储的AK
	public final static String QiNiuStoreAK = PROP.get("QiNiuStoreAK");
	// 七牛云存储的SK
	public final static String QiNiuStoreSK = PROP.get("QiNiuStoreSK");
	// 七牛云存储的桶名称
	public final static String QiNiuStoreBucket = PROP.get("QiNiuStoreBucket");
	// 七牛云存储的区域名称（可选：华东、华北、华南、北美，也可为空，表示自动）
	public final static String QiNiuStoreZone = PROP.get("QiNiuStoreZone", "");
	// 七牛云存储的访问域名
	public final static String QiNiuStoreUrl = PROP.get("QiNiuStoreUrl");

	// 腾讯云存储（COS）的SercertId
	public final static String TencentStoreSId = PROP.get("TencentStoreSId");
	// 腾讯云存储（COS）的SercertKey
	public final static String TencentStoreSKey = PROP.get("TencentStoreSKey");
	// 腾讯云存储（COS）的桶名称，格式为：BucketName-AppId，例如：mybucket-1234567
	public final static String TencentStoreBucket = PROP.get("TencentStoreBucket");
	// 腾讯云存储（COS）的区域别名，例如：ap-beijing
	public final static String TencentStoreZone = PROP.get("TencentStoreZone");
	// 腾讯云存储（COS）的访问域名
	public final static String TencentStoreUrl = PROP.get("TencentStoreUrl");

	/********************* 云服务配置 ********************/
	
	// 腾讯云服务认证配置（secretId）
	public final static String CloudTencentSecretId = PROP.get("CloudTencentSecretId", "");
	// 腾讯云服务认证配置（secretKey）
	public final static String CloudTencentSecretKey = PROP.get("CloudTencentSecretKey", "");

	/********************* 短信方案配置 ********************/
	
	// 默认的短信方案名称：Tencent（腾讯）
	public final static String SmsPlan = PROP.get("SmsPlan", "Tencent");
	
	// 腾讯SMS服务中应用的SdkAppid
	public final static String TencentSmsSdkAppid = PROP.get("TencentSmsSdkAppid", "");

	/********************* 数据缓存方案配置 ********************/
	
	// 缓存方案名称：ehcache、redis、ehredis
	public final static String CachePlan = PROP.get("CachePlan", "ehcache");
	
	// Redis的服务器位置
	public final static String RedisHost = PROP.get("RedisHost", "127.0.0.1");
	// Redis的服务器端口
	public final static Integer RedisPort = PROP.getInt("RedisPort", 6379);
	// Redis的服务密码
	public final static String RedisPass = PROP.get("RedisPass");

	/********************* Session共享方案配置 ********************/
	
	// Session共享方案名称：Db、Cache、Cookie
	public final static String SessionPlan = PROP.get("SessionPlan", "Db");

	/********************* 序列化方案配置 ********************/
	
	// 序列化方案名称：Fst、Fastjson、Kryo
	public final static String SerializerPlan = PROP.get("SerializerPlan", "Fst");

	/********************* 语音合成方案配置 ********************/
	
	// 语音合成（TTS）方案名称：XunFei
	public final static String TtsPlan = PROP.get("TtsPlan", "XunFei");
	public final static String TtsXunFeiUrl = PROP.get("TtsXunFeiUrl", "http://api.xfyun.cn/v1/service/v1/tts");
	public final static Integer TtsXunFeiByteLimit = PROP.getInt("TtsXunFeiByteLimit", 1000);
	public final static String TtsXunFeiAppId = PROP.get("TtsXunFeiAppId", "");
	public final static String TtsXunFeiApiKey = PROP.get("TtsXunFeiApiKey", "");

	/********************* Email服务配置 ********************/
	
	// SMTP主机名称
	public final static String MailHost = PROP.get("MailHost", "smtp.itez.com.cn");
	// SMTP用户名
	public final static String MailUserName = PROP.get("MailUserName", "support@itez.com.cn");
	// SMTP密码
	public final static String MailPassword = PROP.get("MailPassword", "");
	// 发送者称呼
	public final static String MailNickName = PROP.get("MailNickName", "JWinner");

	/********************* 其他杂项配置 ********************/

	// 服务器本地IP，用于向用户显示，个别第三方系统需要将该IP加入信任列表
	public final static String ServerIP = PROP.get("ServerIP", "127.0.0.1");
	// 腾讯位置服务KEY，用于腾讯位置服务的WebServiceAPI接口
	public final static String TencentLBSKey = PROP.get("TencentLBSKey", "TYYBZ-SSTK6-VWMSP-MYKYP-MNW4F-SUBTT");
	// 是否启用定时任务，默认不启动（false）
	public final static Boolean EnableCronTask = PROP.getBoolean("EnableCronTask", false);;
	
	/**
	 * 返回默认配置
	 * @return
	 */
	public static Prop getProp(){
		return PROP;
	}
	
}
