package itez.kit;

import java.math.BigDecimal;

public class ENum {

	/**
	 * 向下取整，即小于这个数的最大的那个整数
	 * @param num
	 * @return
	 */
	public static Integer floor(Object num){
		if(null == num) return null;
		String str = num.toString();
		Double dbl = Double.parseDouble(str);
		return (int)Math.floor(dbl);
	}

	/**
	 * 向上取整，即大于这个数的最小的那个整数
	 * @param num
	 * @return
	 */
	public static Integer ceil(Object num){
		if(null == num) return null;
		String str = num.toString();
		Double dbl = Double.parseDouble(str);
		return (int)Math.ceil(dbl);
	}

	/**
	 * 四舍五入取整
	 * @param num
	 * @return
	 */
	public static Integer round(Object num){
		if(null == num) return null;
		String str = num.toString();
		Double dbl = Double.parseDouble(str);
		return (int)Math.round(dbl);
	}

	/**
	 * 仅保留整数部分
	 * @param num
	 * @return
	 */
	public static Integer toInt(Object num){
		if(null == num) return null;
		String str = num.toString();
		str = str.substring(0, str.indexOf("."));
		return Integer.valueOf(str);
	}
	
	/**
	 * 浮点数加法
	 * @param v1
	 * @param v2
	 * @return
	 */
	public static Double add(double...vs){
		BigDecimal ret = new BigDecimal(0);
		for(Double v : vs){
			BigDecimal vb = new BigDecimal(Double.toString(v));
			ret = ret.add(vb);
		}
        return ret.doubleValue();
    }
	
	/**
	 * 浮点数减法
	 * @param v1 被减数
	 * @param v2
	 * @return
	 */
	public static Double sub(double v1, double...vs){
		BigDecimal ret = new BigDecimal(v1);
		for(Double v : vs){
			BigDecimal vb = new BigDecimal(Double.toString(v));
			ret = ret.subtract(vb);
		}
        return ret.doubleValue();
    }
	
	/**
	 * 浮点数乘法
	 * @param v1
	 * @param v2
	 * @return
	 */
	public static Double mul(double...vs){
		BigDecimal ret = new BigDecimal(1);
		for(Double v : vs){
			BigDecimal vb = new BigDecimal(Double.toString(v));
			ret = ret.multiply(vb);
		}
        return ret.doubleValue();
    }
	
	/**
	 * 浮点数除法
	 * @param v1 被除数
	 * @param v2
	 * @return
	 */
	public static Double div(double v1, double...vs){
		int scale = 10; //除法运算精度
		BigDecimal ret = new BigDecimal(v1);
		for(Double v : vs){
			BigDecimal vb = new BigDecimal(Double.toString(v));
			ret = ret.divide(vb, scale, BigDecimal.ROUND_HALF_UP);
		}
        return ret.doubleValue();
    }
	
	public static void main(String[] args) {
		Object a1 = 0.0;
		Object a2 = 23.56;
		Object a3 = -9.8;
		System.out.println(floor(a1));
		System.out.println(floor(a2));
		System.out.println(floor(a3));
		System.out.println(ceil(a1));
		System.out.println(ceil(a2));
		System.out.println(ceil(a3));
		System.out.println(round(a1));
		System.out.println(round(a2));
		System.out.println(round(a3));
		System.out.println(toInt(a1));
		System.out.println(toInt(a2));
		System.out.println(toInt(a3));
	}
	
}
