package itez.kit;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Base64;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import com.jfinal.kit.HashKit;

/**
 * 字符串编码、解码类
 * 
 * @author netwild
 *
 */
public class ECode {

	private static final String CHARSET = "UTF-8";
	private static final String KEY_ALGORITHM = "AES";
	private static final String CIPHER_ALGORITHM_CBC = "AES/CBC/PKCS5Padding";

	/**
	 * MD5
	 * @param str
	 * @return
	 */
	public static String md5(String str){
		String md5 = HashKit.md5(str);
		return md5;
	}
	
	/**
	 * 生成私盐
	 * @param len
	 * @return
	 */
	public static String generateSalt(int len){
		String salt = HashKit.generateSalt(len);
		return salt;
	}
	
	/**
	 * AES加密
	 * @param str 待加密字符串
	 * @param key 密钥，要求必须为16个字节长度
	 * @return
	 */
	public static String AESEncode(String str, String key) {
		try {
			byte[] strs = str.getBytes(CHARSET);
			byte[] keys = key.getBytes(CHARSET);
			Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_CBC);
			SecretKeySpec skeySpec = new SecretKeySpec(keys, KEY_ALGORITHM);
			IvParameterSpec iv = new IvParameterSpec(getIV());
			cipher.init(Cipher.ENCRYPT_MODE, skeySpec, iv);
			byte[] encrypted = cipher.doFinal(strs);
			String encode = base64Encode(encrypted);
			return encode;
		} catch (Exception e) {
			return null;
		}
	}
	
	/**
	 * AES解密
	 * @param str 待解密的字符串
	 * @param key 密钥，要求必须为16个字节长度
	 * @return
	 */
	public static String AESDecode(String str, String key){
		try{
			byte[] strs = str.getBytes(CHARSET);
			byte[] keys = key.getBytes(CHARSET);
			Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_CBC);
			SecretKeySpec skeySpec = new SecretKeySpec(keys, KEY_ALGORITHM);
			IvParameterSpec iv = new IvParameterSpec(getIV());
			cipher.init(Cipher.DECRYPT_MODE, skeySpec, iv);
			byte[] encrypted = base64Decode2byte(strs);
			byte[] original = cipher.doFinal(encrypted);
			return new String(original, CHARSET);
		} catch (Exception e) {
			return null;
		}
	}
    
	/**
	 * 生成IV，要求必须为16个字节长度
	 * @return
	 */
	private static byte[] getIV() {
		String iv = "1j*W1i#n5N$e6r&^";
		return iv.getBytes();
	}
	
	/**
	 * Base64编码
	 * @param str 待编码的字符串
	 * @return 编码后的字符串
	 */
	public static String base64Encode(String str) {
		byte[] bytes;
		try {
			bytes = str.getBytes(CHARSET);
			return base64Encode(bytes);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			return null;
		}
	}
	
	/**
	 * Base64编码
	 * @param str 待编码的字符串字节数组
	 * @return 编码后的字符串
	 */
	private static String base64Encode(byte[] bytes) {
		return Base64.getUrlEncoder().encodeToString(bytes);
	}

	/**
	 * Base64解码
	 * @param str 待解码的字符串
	 * @return 解码后的字符串
	 */
	public static String base64Decode(String str) {
		try {
			byte[] strs = str.getBytes(CHARSET);
			byte[] bytes = base64Decode2byte(strs);
			return new String(bytes, CHARSET);
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
	}
	
	/**
	 * Base64解码
	 * @param str 待解码的字符串
	 * @return 解码后的字符串字节数组
	 */
	private static byte[] base64Decode2byte(byte[] str) {
		try {
			return Base64.getUrlDecoder().decode(str);
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * 对URL进行URLEncoder编码
	 * @param src 原地址
	 * @return 编码后的地址
	 */
	public static String URLEncode(String src) {
		String requestValue = "";
		try {
			requestValue = URLEncoder.encode(src, CHARSET);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return requestValue;
	}

	/**
	 * 对URL进行URLDecode解码
	 * @param src 待解码地址
	 * @return 解码后的地址
	 */
	public static String URLDecode(String src) {
		String requestValue = "";
		try {
			requestValue = URLDecoder.decode(src, CHARSET);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return requestValue;
	}

	public static void main(String[] args) {
		String salt = HashKit.generateSaltForSha256();
		System.out.println("----------------------------");
		System.out.println("salt：" + salt);
		System.out.println("pass：" + HashKit.md5("zwxgyj" + salt));
		System.out.println("----------------------------");
		System.out.println("Hash MD5加密：");
		System.out.println("----------------------------");
		String strHash = "7735243webvaP3VZJxDF1O8Id8kCLWhopoF4otGECL";
		String strHashen = HashKit.md5(strHash);
		System.out.println("源码值：" + strHash);
		System.out.println("加密后：" + strHashen);
		System.out.println("----------------------------");
		System.out.println("Base64编码与解码：");
		System.out.println("----------------------------");
		String str64 = "abcdefg你好我叫张明玉";
		String str64en = base64Encode(str64);
		String str64de = base64Decode(str64en);
		System.out.println("原始值：" + str64);
		System.out.println("编码后：" + str64en);
		System.out.println("解码后：" + str64de);
		System.out.println("----------------------------");
		System.out.println("URLEncoder编码与解码：");
		System.out.println("----------------------------");
		String strSrc = "http://blog.csdn.net/xiadaoceshen/article/details/8464476";
		String strSrcen = URLEncode(strSrc);
		String strSrcde = URLDecode(strSrcen);
		System.out.println("原始值：" + strSrc);
		System.out.println("编码后：" + strSrcen);
		System.out.println("解码后：" + strSrcde);
		System.out.println("----------------------------");
		System.out.println("AES编码与解码：");
		System.out.println("----------------------------");
		String strAES = "EZPlat";
		String strAESKey = "l2aDS32jFoiWe293";
		String strAESen = AESEncode(strAES, strAESKey);
		String strAESde = AESDecode(strAESen, strAESKey);
		System.out.println("原始值：" + strAES);
		System.out.println("编码后：" + strAESen);
		System.out.println("解码后：" + strAESde);
		System.out.println("----------------------------");
	}

}
