package itez.core.wrapper.render;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;

import com.jfinal.render.Render;
import com.jfinal.render.RenderException;

import itez.kit.EStr;

public class ERenderImage extends Render {

	private String picName;
	private BufferedImage img;
	
	/**
	 * 构造方法
	 * 
	 * @param picName 图片文件名称，不包括扩展名
	 * @param img 图片内容
	 */
	public ERenderImage(String picName, BufferedImage img) {
		this.picName = picName;
		this.img = img;
	}
	
	/**
	 * 导出图片文件
	 * 
	 * @param path 文件保持位置（硬盘路径）
	 * @param extName 扩展名（不包括.）
	 */
	public void export(String path, String extName){
		if(EStr.isEmpty(path)) path = "/";
		if(!path.endsWith("/") && !path.endsWith("\\")) path = path.concat("/");
		String filePath = path.concat(picName).concat(".").concat(extName);
        File file = new File(filePath);
        if (!file.getParentFile().exists()) file.getParentFile().mkdirs();
        try (OutputStream os = new FileOutputStream(file)) {
            ImageIO.write(img, extName.toUpperCase(), os);
        } catch (FileNotFoundException e) {
			error("图片输出目录不存在！");
		} catch (IOException e) {
			error("图片输出失败！");
		}
	}
	
	/**
	 * 渲染图片
	 */
	@Override
	public void render() {
        response.setHeader("Content-Disposition", getFilename());
        response.setHeader("Pragma","no-cache");
        response.setHeader("Cache-Control","no-cache");
        response.setDateHeader("Expires", 0);
        response.setContentType("image/jpeg");
        ServletOutputStream sos = null;
        try {
            sos = response.getOutputStream();
            ImageIO.write(img, "jpeg", sos);
        } catch (IOException e) {
            if (getDevMode()) {
                throw new RenderException(e);
            }
        } catch (Exception e) {
            throw new RenderException(e);
        } finally {
            if (sos != null) {
                try {sos.close();} catch (IOException e) {e.printStackTrace();}
            }
        }
	}
 
    protected String getFilename() {
        try {
            String agent = request.getHeader("USER-AGENT");
            if (agent.toLowerCase().indexOf("firefox") > 0) {
            	picName = new String(picName.getBytes("utf-8"), "iso-8859-1");
            } else {
            	picName = URLEncoder.encode(picName, "UTF-8");
            }
        } catch (UnsupportedEncodingException e) {
            error(e.getMessage());
        }
        return "attachment; filename=" + picName + ".jpg";
    }
    
    protected void error(String msg) {
		throw new RuntimeException(msg);
	}

}
